package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaTmallnftNftPresendResponse;

/**
 * TOP API: alibaba.tmallnft.nft.presend request
 * 
 * @author top auto create
 * @since 1.0, 2022.05.12
 */
public class AlibabaTmallnftNftPresendRequest extends BaseTaobaoRequest<AlibabaTmallnftNftPresendResponse> {
	
	

	/** 
	* 数字藏品id
	 */
	private Long collectionId;

	/** 
	* openid
	 */
	private String openid;

	public void setCollectionId(Long collectionId) {
		this.collectionId = collectionId;
	}

	public Long getCollectionId() {
		return this.collectionId;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getOpenid() {
		return this.openid;
	}

	public String getApiMethodName() {
		return "alibaba.tmallnft.nft.presend";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("collection_id", this.collectionId);
		txtParams.put("openid", this.openid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaTmallnftNftPresendResponse> getResponseClass() {
		return AlibabaTmallnftNftPresendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(collectionId, "collectionId");
		RequestCheckUtils.checkNotEmpty(openid, "openid");
	}
	

}