package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.FpAccountInfoQueryResponse;

/**
 * TOP API: taobao.fp.account.info.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.06
 */
public class FpAccountInfoQueryRequest extends BaseTaobaoRequest<FpAccountInfoQueryResponse> {
	
	

	/** 
	* 请求参数
	 */
	private String req;

	public void setReq(String req) {
		this.req = req;
	}

	public void setReq(AccountQueryByBizIdAndSpecReqDTO req) {
		this.req = new JSONWriter(false,true).write(req);
	}

	public String getReq() {
		return this.req;
	}

	public String getApiMethodName() {
		return "taobao.fp.account.info.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("req", this.req);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FpAccountInfoQueryResponse> getResponseClass() {
		return FpAccountInfoQueryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 请求参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AccountQueryByBizIdAndSpecReqDTO extends TaobaoObject {

	private static final long serialVersionUID = 5268513584873132279L;

	/**
		 * 账户描述码
		 */
		@ApiField("acct_spec_code")
		private String acctSpecCode;
		/**
		 * 业务号
		 */
		@ApiField("biz_id")
		private String bizId;
	

	public String getAcctSpecCode() {
			return this.acctSpecCode;
		}
		public void setAcctSpecCode(String acctSpecCode) {
			this.acctSpecCode = acctSpecCode;
		}
		public String getBizId() {
			return this.bizId;
		}
		public void setBizId(String bizId) {
			this.bizId = bizId;
		}

}


}