package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JuHjsfeedsGetResponse;

/**
 * TOP API: taobao.ju.hjsfeeds.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class JuHjsfeedsGetRequest extends BaseTaobaoRequest<JuHjsfeedsGetResponse> {
	
	

	/** 
	* 系统自动生成
	 */
	private String requestItems;

	public void setRequestItems(String requestItems) {
		this.requestItems = requestItems;
	}

	public void setRequestItems(List<ResultList> requestItems) {
		this.requestItems = new JSONWriter(false,true).write(requestItems);
	}

	public String getRequestItems() {
		return this.requestItems;
	}

	public String getApiMethodName() {
		return "taobao.ju.hjsfeeds.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("request_items", this.requestItems);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JuHjsfeedsGetResponse> getResponseClass() {
		return JuHjsfeedsGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(requestItems, 999, "requestItems");
	}
	
	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 2645756663838792644L;

	/**
		 * 系统自动生成
		 */
		@ApiField("from")
		private String from;
		/**
		 * 页数:从1开始
		 */
		@ApiField("page")
		private Long page;
		/**
		 * 单页个数
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * API版本号
		 */
		@ApiField("version")
		private Long version;
	

	public String getFrom() {
			return this.from;
		}
		public void setFrom(String from) {
			this.from = from;
		}
		public Long getPage() {
			return this.page;
		}
		public void setPage(Long page) {
			this.page = page;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Long getVersion() {
			return this.version;
		}
		public void setVersion(Long version) {
			this.version = version;
		}

}

	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultList extends TaobaoObject {

	private static final long serialVersionUID = 8668419794736722148L;

	/**
		 * 系统自动生成
		 */
		@ApiField("data")
		private Result data;
		/**
		 * 系统自动生成
		 */
		@ApiField("res_id")
		private String resId;
		/**
		 * 系统自动生成
		 */
		@ApiField("res_id_mapping")
		private String resIdMapping;
	

	public Result getData() {
			return this.data;
		}
		public void setData(Result data) {
			this.data = data;
		}
		public String getResId() {
			return this.resId;
		}
		public void setResId(String resId) {
			this.resId = resId;
		}
		public String getResIdMapping() {
			return this.resIdMapping;
		}
		public void setResIdMapping(String resIdMapping) {
			this.resIdMapping = resIdMapping;
		}

}


}