package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.MobilePromotionCouponApplyResponse;

/**
 * TOP API: taobao.mobile.promotion.coupon.apply request
 * 
 * @author top auto create
 * @since 1.0, 2018.11.10
 */
public class MobilePromotionCouponApplyRequest extends BaseTaobaoRequest<MobilePromotionCouponApplyResponse> {
	
	

	/** 
	* 三方活动id
	 */
	private String bizId;

	/** 
	* 广播id
	 */
	private String feedId;

	/** 
	* 传播id
	 */
	private Long spreadId;

	/** 
	* 请求唯一id，问题排查
	 */
	private String traceId;

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getBizId() {
		return this.bizId;
	}

	public void setFeedId(String feedId) {
		this.feedId = feedId;
	}

	public String getFeedId() {
		return this.feedId;
	}

	public void setSpreadId(Long spreadId) {
		this.spreadId = spreadId;
	}

	public Long getSpreadId() {
		return this.spreadId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getTraceId() {
		return this.traceId;
	}

	public String getApiMethodName() {
		return "taobao.mobile.promotion.coupon.apply";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_id", this.bizId);
		txtParams.put("feed_id", this.feedId);
		txtParams.put("spread_id", this.spreadId);
		txtParams.put("trace_id", this.traceId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<MobilePromotionCouponApplyResponse> getResponseClass() {
		return MobilePromotionCouponApplyResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizId, "bizId");
		RequestCheckUtils.checkNotEmpty(feedId, "feedId");
		RequestCheckUtils.checkNotEmpty(spreadId, "spreadId");
		RequestCheckUtils.checkNotEmpty(traceId, "traceId");
	}
	

}