package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.MobilePromotionCouponSellerSearchResponse;

/**
 * TOP API: taobao.mobile.promotion.coupon.seller.search request
 * 
 * @author top auto create
 * @since 1.0, 2018.11.10
 */
public class MobilePromotionCouponSellerSearchRequest extends BaseTaobaoRequest<MobilePromotionCouponSellerSearchResponse> {
	
	

	/** 
	* 当前第几页 从第一页开始
	 */
	private Long currentPage;

	/** 
	* 每页数据 最大20左右
	 */
	private Long pageSize;

	/** 
	* 券id集合
	 */
	private String spreadIds;

	/** 
	* 请求id 排查线索 需保证单次调用唯一
	 */
	private String traceId;

	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public Long getCurrentPage() {
		return this.currentPage;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setSpreadIds(String spreadIds) {
		this.spreadIds = spreadIds;
	}

	public String getSpreadIds() {
		return this.spreadIds;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getTraceId() {
		return this.traceId;
	}

	public String getApiMethodName() {
		return "taobao.mobile.promotion.coupon.seller.search";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("current_page", this.currentPage);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("spread_ids", this.spreadIds);
		txtParams.put("trace_id", this.traceId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<MobilePromotionCouponSellerSearchResponse> getResponseClass() {
		return MobilePromotionCouponSellerSearchResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}