package com.taobao.api.request;

import com.taobao.api.domain.BatchSendRequest;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionBenefitActivityBatchSendResponse;

/**
 * TOP API: taobao.promotion.benefit.activity.batch.send request
 * 
 * @author top auto create
 * @since 1.0, 2015.06.12
 */
public class PromotionBenefitActivityBatchSendRequest extends BaseTaobaoRequest<PromotionBenefitActivityBatchSendResponse> {
	
	

	/** 
	* 批量发放请求
	 */
	private String batchRequest;

	public void setBatchRequest(String batchRequest) {
		this.batchRequest = batchRequest;
	}

	public void setBatchRequest(BatchSendRequest batchRequest) {
		this.batchRequest = new JSONWriter(false,true).write(batchRequest);
	}

	public String getBatchRequest() {
		return this.batchRequest;
	}

	public String getApiMethodName() {
		return "taobao.promotion.benefit.activity.batch.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("batch_request", this.batchRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionBenefitActivityBatchSendResponse> getResponseClass() {
		return PromotionBenefitActivityBatchSendResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}