package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionBenefitActivityDeleteResponse;

/**
 * TOP API: taobao.promotion.benefit.activity.delete request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.20
 */
public class PromotionBenefitActivityDeleteRequest extends BaseTaobaoRequest<PromotionBenefitActivityDeleteResponse> {
	
	

	/** 
	* ISV活动关联权益后获得的关联ID
	 */
	private Long relationId;

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Long getRelationId() {
		return this.relationId;
	}

	public String getApiMethodName() {
		return "taobao.promotion.benefit.activity.delete";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("relation_id", this.relationId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionBenefitActivityDeleteResponse> getResponseClass() {
		return PromotionBenefitActivityDeleteResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(relationId, "relationId");
	}
	

}