package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionBenefitActivitySendResponse;

/**
 * TOP API: taobao.promotion.benefit.activity.send request
 * 
 * @author top auto create
 * @since 1.0, 2022.07.29
 */
public class PromotionBenefitActivitySendRequest extends BaseTaobaoRequest<PromotionBenefitActivitySendResponse> {
	
	

	/** 
	* 混淆的接收者id
	 */
	private String mixReceiverId;

	/** 
	* 混淆的接收者nick
	 */
	private String nick;

	/** 
	* ouid
	 */
	private String ouid;

	/** 
	* 非混淆的接收者nick
	 */
	private String platNick;

	/** 
	* 非混淆的接收者id
	 */
	private Long receiverId;

	/** 
	* 单个权益发放请求
	 */
	private String sendRequest;

	/** 
	* openid
	 */
	private String uid;

	public void setMixReceiverId(String mixReceiverId) {
		this.mixReceiverId = mixReceiverId;
	}

	public String getMixReceiverId() {
		return this.mixReceiverId;
	}

	public void setNick(String nick) {
		this.nick = nick;
	}

	public String getNick() {
		return this.nick;
	}

	public void setOuid(String ouid) {
		this.ouid = ouid;
	}

	public String getOuid() {
		return this.ouid;
	}

	public void setPlatNick(String platNick) {
		this.platNick = platNick;
	}

	public String getPlatNick() {
		return this.platNick;
	}

	public void setReceiverId(Long receiverId) {
		this.receiverId = receiverId;
	}

	public Long getReceiverId() {
		return this.receiverId;
	}

	public void setSendRequest(String sendRequest) {
		this.sendRequest = sendRequest;
	}

	public void setSendRequest(BenefitSingleSendRequest sendRequest) {
		this.sendRequest = new JSONWriter(false,true).write(sendRequest);
	}

	public String getSendRequest() {
		return this.sendRequest;
	}

	public void setUid(String uid) {
		this.uid = uid;
	}

	public String getUid() {
		return this.uid;
	}

	public String getApiMethodName() {
		return "taobao.promotion.benefit.activity.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("mix_receiver_id", this.mixReceiverId);
		txtParams.put("nick", this.nick);
		txtParams.put("ouid", this.ouid);
		txtParams.put("plat_nick", this.platNick);
		txtParams.put("receiver_id", this.receiverId);
		txtParams.put("send_request", this.sendRequest);
		txtParams.put("uid", this.uid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionBenefitActivitySendResponse> getResponseClass() {
		return PromotionBenefitActivitySendResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 单个权益发放请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BenefitSingleSendRequest extends TaobaoObject {

	private static final long serialVersionUID = 2337993471441415645L;

	/**
		 * 权益类型
		 */
		@ApiField("benefit_type")
		private String benefitType;
		/**
		 * 活动详情id
		 */
		@ApiField("detail_id")
		private Long detailId;
		/**
		 * 活动id
		 */
		@ApiField("relation_id")
		private Long relationId;
		/**
		 * 权益发放数量
		 */
		@ApiField("send_count")
		private Long sendCount;
		/**
		 * 幂等ID，代表一次发放。如，超时重试，需要保证幂等ID不变。不同的幂等ID代表两次不同得发放，因业务方更换幂等ID导致的超发问题由业务方负责
		 */
		@ApiField("unique_id")
		private String uniqueId;
	

	public String getBenefitType() {
			return this.benefitType;
		}
		public void setBenefitType(String benefitType) {
			this.benefitType = benefitType;
		}
		public Long getDetailId() {
			return this.detailId;
		}
		public void setDetailId(Long detailId) {
			this.detailId = detailId;
		}
		public Long getRelationId() {
			return this.relationId;
		}
		public void setRelationId(Long relationId) {
			this.relationId = relationId;
		}
		public Long getSendCount() {
			return this.sendCount;
		}
		public void setSendCount(Long sendCount) {
			this.sendCount = sendCount;
		}
		public String getUniqueId() {
			return this.uniqueId;
		}
		public void setUniqueId(String uniqueId) {
			this.uniqueId = uniqueId;
		}

}


}