package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionBenefitSelectorResponse;

/**
 * TOP API: taobao.promotion.benefit.selector request
 * 
 * @author top auto create
 * @since 1.0, 2023.03.16
 */
public class PromotionBenefitSelectorRequest extends BaseTaobaoRequest<PromotionBenefitSelectorResponse> {
	
	

	/** 
	* 权益选择器请求
	 */
	private String query;

	public void setQuery(String query) {
		this.query = query;
	}

	public void setQuery(BenefitSelectorQuery query) {
		this.query = new JSONWriter(false,true).write(query);
	}

	public String getQuery() {
		return this.query;
	}

	public String getApiMethodName() {
		return "taobao.promotion.benefit.selector";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("query", this.query);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionBenefitSelectorResponse> getResponseClass() {
		return PromotionBenefitSelectorResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 权益选择器请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BenefitSelectorQuery extends TaobaoObject {

	private static final long serialVersionUID = 8798117578576195566L;

	/**
		 * 权益id（步骤3必填）
		 */
		@ApiField("benefit_id")
		private Long benefitId;
		/**
		 * 权益类型（步骤2,3必填）
		 */
		@ApiField("benefit_type")
		private String benefitType;
		/**
		 * 新权益类型id
		 */
		@ApiField("config_id")
		private Long configId;
		/**
		 * 选择器步骤选择2时，查询指定类型权益列表分页查询参数
		 */
		@ApiField("current_page")
		private Long currentPage;
		/**
		 * 需要过滤的option
		 */
		@ApiField("exclude_options")
		private Long excludeOptions;
		/**
		 * 传true时列表进行分页查询，分页查询时不会对发放完的模板过滤；传false时分页查询的current_page和page_size不传，接口语义和之前一致。
		 */
		@ApiField("page_query_request")
		private Boolean pageQueryRequest;
		/**
		 * 选择器步骤选择2时，查询指定类型权益列表分页查询参数
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 选择器步骤可选1,2,3，1：展示卖家能够选择的权益类型2：必填BenefitType，展示卖家该种类型下的权益3：必填BenefitType和benefitId，展示卖家该权益的详情
		 */
		@ApiField("step")
		private Long step;
	

	public Long getBenefitId() {
			return this.benefitId;
		}
		public void setBenefitId(Long benefitId) {
			this.benefitId = benefitId;
		}
		public String getBenefitType() {
			return this.benefitType;
		}
		public void setBenefitType(String benefitType) {
			this.benefitType = benefitType;
		}
		public Long getConfigId() {
			return this.configId;
		}
		public void setConfigId(Long configId) {
			this.configId = configId;
		}
		public Long getCurrentPage() {
			return this.currentPage;
		}
		public void setCurrentPage(Long currentPage) {
			this.currentPage = currentPage;
		}
		public Long getExcludeOptions() {
			return this.excludeOptions;
		}
		public void setExcludeOptions(Long excludeOptions) {
			this.excludeOptions = excludeOptions;
		}
		public Boolean getPageQueryRequest() {
			return this.pageQueryRequest;
		}
		public void setPageQueryRequest(Boolean pageQueryRequest) {
			this.pageQueryRequest = pageQueryRequest;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Long getStep() {
			return this.step;
		}
		public void setStep(Long step) {
			this.step = step;
		}

}


}