package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionCouponSellerSearchResponse;

/**
 * TOP API: taobao.promotion.coupon.seller.search request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.20
 */
public class PromotionCouponSellerSearchRequest extends BaseTaobaoRequest<PromotionCouponSellerSearchResponse> {
	
	

	/** 
	* 当前第几页  从第一页开始
	 */
	private Long currentPage;

	/** 
	* 每页数据 最大20左右
	 */
	private Long pageSize;

	/** 
	* 卖家昵称
	 */
	private String sellerNick;

	/** 
	* 券id集合
	 */
	private String spreadIds;

	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public Long getCurrentPage() {
		return this.currentPage;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setSellerNick(String sellerNick) {
		this.sellerNick = sellerNick;
	}

	public String getSellerNick() {
		return this.sellerNick;
	}

	public void setSpreadIds(String spreadIds) {
		this.spreadIds = spreadIds;
	}

	public String getSpreadIds() {
		return this.spreadIds;
	}

	public String getApiMethodName() {
		return "taobao.promotion.coupon.seller.search";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("current_page", this.currentPage);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("seller_nick", this.sellerNick);
		txtParams.put("spread_ids", this.spreadIds);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionCouponSellerSearchResponse> getResponseClass() {
		return PromotionCouponSellerSearchResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMinValue(currentPage, 1L, "currentPage");
		RequestCheckUtils.checkMaxValue(pageSize, 20L, "pageSize");
		RequestCheckUtils.checkMinValue(pageSize, 1L, "pageSize");
		RequestCheckUtils.checkMaxListSize(spreadIds, 20, "spreadIds");
	}
	

}