package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionCouponSpreadApplyResponse;

/**
 * TOP API: taobao.promotion.coupon.spread.apply request
 * 
 * @author top auto create
 * @since 1.0, 2016.06.21
 */
public class PromotionCouponSpreadApplyRequest extends BaseTaobaoRequest<PromotionCouponSpreadApplyResponse> {
	
	

	/** 
	* 卡券领取渠道Id
	 */
	private Long couponInstanceSource;

	/** 
	* 卡券活动Id
	 */
	private Long querySource;

	/** 
	* 卖家Id
	 */
	private String sellerId;

	/** 
	* 卡券传播uuid
	 */
	private String uuid;

	public void setCouponInstanceSource(Long couponInstanceSource) {
		this.couponInstanceSource = couponInstanceSource;
	}

	public Long getCouponInstanceSource() {
		return this.couponInstanceSource;
	}

	public void setQuerySource(Long querySource) {
		this.querySource = querySource;
	}

	public Long getQuerySource() {
		return this.querySource;
	}

	public void setSellerId(String sellerId) {
		this.sellerId = sellerId;
	}

	public String getSellerId() {
		return this.sellerId;
	}

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	public String getUuid() {
		return this.uuid;
	}

	public String getApiMethodName() {
		return "taobao.promotion.coupon.spread.apply";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("coupon_instance_source", this.couponInstanceSource);
		txtParams.put("query_source", this.querySource);
		txtParams.put("seller_id", this.sellerId);
		txtParams.put("uuid", this.uuid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionCouponSpreadApplyResponse> getResponseClass() {
		return PromotionCouponSpreadApplyResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(sellerId, "sellerId");
		RequestCheckUtils.checkNotEmpty(uuid, "uuid");
	}
	

}