package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionVoucherRecoverResponse;

/**
 * TOP API: taobao.promotion.voucher.recover request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class PromotionVoucherRecoverRequest extends BaseTaobaoRequest<PromotionVoucherRecoverResponse> {
	
	

	/** 
	* 买家ID，卡券拥有者
	 */
	private Long buyerId;

	/** 
	* 外部卡券实例ID
	 */
	private String outInstanceId;

	/** 
	* 外部实例类型，口碑-58
	 */
	private Long outInstanceType;

	public void setBuyerId(Long buyerId) {
		this.buyerId = buyerId;
	}

	public Long getBuyerId() {
		return this.buyerId;
	}

	public void setOutInstanceId(String outInstanceId) {
		this.outInstanceId = outInstanceId;
	}

	public String getOutInstanceId() {
		return this.outInstanceId;
	}

	public void setOutInstanceType(Long outInstanceType) {
		this.outInstanceType = outInstanceType;
	}

	public Long getOutInstanceType() {
		return this.outInstanceType;
	}

	public String getApiMethodName() {
		return "taobao.promotion.voucher.recover";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_id", this.buyerId);
		txtParams.put("out_instance_id", this.outInstanceId);
		txtParams.put("out_instance_type", this.outInstanceType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionVoucherRecoverResponse> getResponseClass() {
		return PromotionVoucherRecoverResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(buyerId, "buyerId");
		RequestCheckUtils.checkNotEmpty(outInstanceId, "outInstanceId");
		RequestCheckUtils.checkNotEmpty(outInstanceType, "outInstanceType");
	}
	

}