package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionVoucherSyncResponse;

/**
 * TOP API: taobao.promotion.voucher.sync request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class PromotionVoucherSyncRequest extends BaseTaobaoRequest<PromotionVoucherSyncResponse> {
	
	

	/** 
	* 同步卡券实例
	 */
	private String voucherDto;

	public void setVoucherDto(String voucherDto) {
		this.voucherDto = voucherDto;
	}

	public void setVoucherDto(VoucherDTO voucherDto) {
		this.voucherDto = new JSONWriter(false,true).write(voucherDto);
	}

	public String getVoucherDto() {
		return this.voucherDto;
	}

	public String getApiMethodName() {
		return "taobao.promotion.voucher.sync";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("voucher_dto", this.voucherDto);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionVoucherSyncResponse> getResponseClass() {
		return PromotionVoucherSyncResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 券的扩展属性
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponFeature extends TaobaoObject {

	private static final long serialVersionUID = 2615888226981968293L;

	/**
		 * 详细说明URL
		 */
		@ApiField("detail_instruction_url")
		private String detailInstructionUrl;
		/**
		 * 商户Logo或品牌Logo
		 */
		@ApiField("supplier_logo")
		private String supplierLogo;
	

	public String getDetailInstructionUrl() {
			return this.detailInstructionUrl;
		}
		public void setDetailInstructionUrl(String detailInstructionUrl) {
			this.detailInstructionUrl = detailInstructionUrl;
		}
		public String getSupplierLogo() {
			return this.supplierLogo;
		}
		public void setSupplierLogo(String supplierLogo) {
			this.supplierLogo = supplierLogo;
		}

}

	/**
 * 卡券权益信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CouponFunction extends TaobaoObject {

	private static final long serialVersionUID = 6694493283482368743L;

	/**
		 * 券面额，单位分
		 */
		@ApiField("amount")
		private Long amount;
		/**
		 * 折扣信息
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 使用门槛，单位分
		 */
		@ApiField("start_fee")
		private Long startFee;
	

	public Long getAmount() {
			return this.amount;
		}
		public void setAmount(Long amount) {
			this.amount = amount;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public Long getStartFee() {
			return this.startFee;
		}
		public void setStartFee(Long startFee) {
			this.startFee = startFee;
		}

}

	/**
 * 券实例扩展属性
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InstanceFeature extends TaobaoObject {

	private static final long serialVersionUID = 6592912191935887632L;

	/**
		 * 行动点URL
		 */
		@ApiField("action_point_url")
		private String actionPointUrl;
		/**
		 * 扩展使用说明1 内容
		 */
		@ApiField("instruction1")
		private String instruction1;
		/**
		 * 扩展使用说明1 标题
		 */
		@ApiField("instruction1_title")
		private String instruction1Title;
		/**
		 * 扩展使用说明1 图片地址
		 */
		@ApiField("instruction1_url")
		private String instruction1Url;
		/**
		 * 扩展使用说明2 内容
		 */
		@ApiField("instruction2")
		private String instruction2;
		/**
		 * 扩展使用说明2 标题
		 */
		@ApiField("instruction2_title")
		private String instruction2Title;
		/**
		 * 口碑门店h5链接
		 */
		@ApiField("instruction2_url")
		private String instruction2Url;
		/**
		 * 扩展使用说明3 内容
		 */
		@ApiField("instruction3")
		private String instruction3;
		/**
		 * 扩展使用说明3 标题
		 */
		@ApiField("instruction3_title")
		private String instruction3Title;
		/**
		 * 扩展使用说明3 图片地址
		 */
		@ApiField("instruction3_url")
		private String instruction3Url;
	

	public String getActionPointUrl() {
			return this.actionPointUrl;
		}
		public void setActionPointUrl(String actionPointUrl) {
			this.actionPointUrl = actionPointUrl;
		}
		public String getInstruction1() {
			return this.instruction1;
		}
		public void setInstruction1(String instruction1) {
			this.instruction1 = instruction1;
		}
		public String getInstruction1Title() {
			return this.instruction1Title;
		}
		public void setInstruction1Title(String instruction1Title) {
			this.instruction1Title = instruction1Title;
		}
		public String getInstruction1Url() {
			return this.instruction1Url;
		}
		public void setInstruction1Url(String instruction1Url) {
			this.instruction1Url = instruction1Url;
		}
		public String getInstruction2() {
			return this.instruction2;
		}
		public void setInstruction2(String instruction2) {
			this.instruction2 = instruction2;
		}
		public String getInstruction2Title() {
			return this.instruction2Title;
		}
		public void setInstruction2Title(String instruction2Title) {
			this.instruction2Title = instruction2Title;
		}
		public String getInstruction2Url() {
			return this.instruction2Url;
		}
		public void setInstruction2Url(String instruction2Url) {
			this.instruction2Url = instruction2Url;
		}
		public String getInstruction3() {
			return this.instruction3;
		}
		public void setInstruction3(String instruction3) {
			this.instruction3 = instruction3;
		}
		public String getInstruction3Title() {
			return this.instruction3Title;
		}
		public void setInstruction3Title(String instruction3Title) {
			this.instruction3Title = instruction3Title;
		}
		public String getInstruction3Url() {
			return this.instruction3Url;
		}
		public void setInstruction3Url(String instruction3Url) {
			this.instruction3Url = instruction3Url;
		}

}

	/**
 * 同步卡券实例
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class VoucherDTO extends TaobaoObject {

	private static final long serialVersionUID = 2667147112231783784L;

	/**
		 * 所属商业单元，0 未分组
		 */
		@ApiField("business_unit")
		private Long businessUnit;
		/**
		 * 买家ID，获得券的人的ID
		 */
		@ApiField("buyer_id")
		private Long buyerId;
		/**
		 * 券的扩展属性
		 */
		@ApiField("coupon_feature")
		private CouponFeature couponFeature;
		/**
		 * 卡券权益信息
		 */
		@ApiField("coupon_function")
		private CouponFunction couponFunction;
		/**
		 * 卡券属性标志
		 */
		@ApiField("coupon_tag")
		private String couponTag;
		/**
		 * 卡券类型，如口碑券-258
		 */
		@ApiField("coupon_type")
		private Long couponType;
		/**
		 * 电子凭证数量 必填
		 */
		@ApiField("instance_count")
		private Long instanceCount;
		/**
		 * 券实例扩展属性
		 */
		@ApiField("instance_feature")
		private InstanceFeature instanceFeature;
		/**
		 * 使用说明
		 */
		@ApiField("instruction")
		private String instruction;
		/**
		 * 备注
		 */
		@ApiField("memo")
		private String memo;
		/**
		 * 外部卡券类型ID
		 */
		@ApiField("out_coupon_id")
		private String outCouponId;
		/**
		 * 外部卡券类型，自定义
		 */
		@ApiField("out_coupon_type")
		private Long outCouponType;
		/**
		 * 外部实例id，自定义，唯一
		 */
		@ApiField("out_instance_id")
		private String outInstanceId;
		/**
		 * 外部实例类型，如口碑券-58
		 */
		@ApiField("out_instance_type")
		private Long outInstanceType;
		/**
		 * 图片地址，多张图片";"隔开
		 */
		@ApiField("pictures")
		private String pictures;
		/**
		 * 凭证皮肤
		 */
		@ApiField("skin")
		private String skin;
		/**
		 * 卡券实例状态，1-可使用，0-冻结中，-1-已删除，-2-已使用
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 门店数量
		 */
		@ApiField("store_num")
		private Long storeNum;
		/**
		 * 商户id，自定义
		 */
		@ApiField("supplier_id")
		private Long supplierId;
		/**
		 * 商户类型，天猫淘宝-1
		 */
		@ApiField("supplier_type")
		private Long supplierType;
		/**
		 * 是否支持门店
		 */
		@ApiField("support_store")
		private Boolean supportStore;
		/**
		 * 卡券包展示标题
		 */
		@ApiField("title")
		private String title;
		/**
		 * 卡券失效时间，活动结束
		 */
		@ApiField("voucher_end_time")
		private Date voucherEndTime;
		/**
		 * 卡券生效时间，活动开始
		 */
		@ApiField("voucher_start_time")
		private Date voucherStartTime;
	

	public Long getBusinessUnit() {
			return this.businessUnit;
		}
		public void setBusinessUnit(Long businessUnit) {
			this.businessUnit = businessUnit;
		}
		public Long getBuyerId() {
			return this.buyerId;
		}
		public void setBuyerId(Long buyerId) {
			this.buyerId = buyerId;
		}
		public CouponFeature getCouponFeature() {
			return this.couponFeature;
		}
		public void setCouponFeature(CouponFeature couponFeature) {
			this.couponFeature = couponFeature;
		}
		public CouponFunction getCouponFunction() {
			return this.couponFunction;
		}
		public void setCouponFunction(CouponFunction couponFunction) {
			this.couponFunction = couponFunction;
		}
		public String getCouponTag() {
			return this.couponTag;
		}
		public void setCouponTag(String couponTag) {
			this.couponTag = couponTag;
		}
		public Long getCouponType() {
			return this.couponType;
		}
		public void setCouponType(Long couponType) {
			this.couponType = couponType;
		}
		public Long getInstanceCount() {
			return this.instanceCount;
		}
		public void setInstanceCount(Long instanceCount) {
			this.instanceCount = instanceCount;
		}
		public InstanceFeature getInstanceFeature() {
			return this.instanceFeature;
		}
		public void setInstanceFeature(InstanceFeature instanceFeature) {
			this.instanceFeature = instanceFeature;
		}
		public String getInstruction() {
			return this.instruction;
		}
		public void setInstruction(String instruction) {
			this.instruction = instruction;
		}
		public String getMemo() {
			return this.memo;
		}
		public void setMemo(String memo) {
			this.memo = memo;
		}
		public String getOutCouponId() {
			return this.outCouponId;
		}
		public void setOutCouponId(String outCouponId) {
			this.outCouponId = outCouponId;
		}
		public Long getOutCouponType() {
			return this.outCouponType;
		}
		public void setOutCouponType(Long outCouponType) {
			this.outCouponType = outCouponType;
		}
		public String getOutInstanceId() {
			return this.outInstanceId;
		}
		public void setOutInstanceId(String outInstanceId) {
			this.outInstanceId = outInstanceId;
		}
		public Long getOutInstanceType() {
			return this.outInstanceType;
		}
		public void setOutInstanceType(Long outInstanceType) {
			this.outInstanceType = outInstanceType;
		}
		public String getPictures() {
			return this.pictures;
		}
		public void setPictures(String pictures) {
			this.pictures = pictures;
		}
		public String getSkin() {
			return this.skin;
		}
		public void setSkin(String skin) {
			this.skin = skin;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getStoreNum() {
			return this.storeNum;
		}
		public void setStoreNum(Long storeNum) {
			this.storeNum = storeNum;
		}
		public Long getSupplierId() {
			return this.supplierId;
		}
		public void setSupplierId(Long supplierId) {
			this.supplierId = supplierId;
		}
		public Long getSupplierType() {
			return this.supplierType;
		}
		public void setSupplierType(Long supplierType) {
			this.supplierType = supplierType;
		}
		public Boolean getSupportStore() {
			return this.supportStore;
		}
		public void setSupportStore(Boolean supportStore) {
			this.supportStore = supportStore;
		}
		public String getTitle() {
			return this.title;
		}
		public void setTitle(String title) {
			this.title = title;
		}
		public Date getVoucherEndTime() {
			return this.voucherEndTime;
		}
		public void setVoucherEndTime(Date voucherEndTime) {
			this.voucherEndTime = voucherEndTime;
		}
		public Date getVoucherStartTime() {
			return this.voucherStartTime;
		}
		public void setVoucherStartTime(Date voucherStartTime) {
			this.voucherStartTime = voucherStartTime;
		}

}


}