package com.taobao.api.request;

import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionVoucherTconRecoverResponse;

/**
 * TOP API: taobao.promotion.voucher.tcon.recover request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class PromotionVoucherTconRecoverRequest extends BaseTaobaoRequest<PromotionVoucherTconRecoverResponse> {
	
	

	/** 
	* 买家ID
	 */
	private Long buyerId;

	/** 
	* 外部实例ID
	 */
	private String outInstanceId;

	/** 
	* 外部实例类型
	 */
	private Long outInstanceType;

	/** 
	* 时间戳
	 */
	private Date tconTimestamp;

	public void setBuyerId(Long buyerId) {
		this.buyerId = buyerId;
	}

	public Long getBuyerId() {
		return this.buyerId;
	}

	public void setOutInstanceId(String outInstanceId) {
		this.outInstanceId = outInstanceId;
	}

	public String getOutInstanceId() {
		return this.outInstanceId;
	}

	public void setOutInstanceType(Long outInstanceType) {
		this.outInstanceType = outInstanceType;
	}

	public Long getOutInstanceType() {
		return this.outInstanceType;
	}

	public void setTconTimestamp(Date tconTimestamp) {
		this.tconTimestamp = tconTimestamp;
	}

	public Date getTconTimestamp() {
		return this.tconTimestamp;
	}

	public String getApiMethodName() {
		return "taobao.promotion.voucher.tcon.recover";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_id", this.buyerId);
		txtParams.put("out_instance_id", this.outInstanceId);
		txtParams.put("out_instance_type", this.outInstanceType);
		txtParams.put("tcon_timestamp", this.tconTimestamp);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionVoucherTconRecoverResponse> getResponseClass() {
		return PromotionVoucherTconRecoverResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}