package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionVoucherWriteoffResponse;

/**
 * TOP API: taobao.promotion.voucher.writeoff request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.20
 */
public class PromotionVoucherWriteoffRequest extends BaseTaobaoRequest<PromotionVoucherWriteoffResponse> {
	
	

	/** 
	* 买家ID，即卡券拥有者ID
	 */
	private Long buyerId;

	/** 
	* 外部实例ID
	 */
	private String outInstanceId;

	/** 
	* 外部实例类型，如口碑-58
	 */
	private Long outInstanceType;

	public void setBuyerId(Long buyerId) {
		this.buyerId = buyerId;
	}

	public Long getBuyerId() {
		return this.buyerId;
	}

	public void setOutInstanceId(String outInstanceId) {
		this.outInstanceId = outInstanceId;
	}

	public String getOutInstanceId() {
		return this.outInstanceId;
	}

	public void setOutInstanceType(Long outInstanceType) {
		this.outInstanceType = outInstanceType;
	}

	public Long getOutInstanceType() {
		return this.outInstanceType;
	}

	public String getApiMethodName() {
		return "taobao.promotion.voucher.writeoff";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_id", this.buyerId);
		txtParams.put("out_instance_id", this.outInstanceId);
		txtParams.put("out_instance_type", this.outInstanceType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionVoucherWriteoffResponse> getResponseClass() {
		return PromotionVoucherWriteoffResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(buyerId, "buyerId");
		RequestCheckUtils.checkNotEmpty(outInstanceId, "outInstanceId");
		RequestCheckUtils.checkNotEmpty(outInstanceType, "outInstanceType");
	}
	

}