package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionYoukucardHttpGetResponse;

/**
 * TOP API: taobao.promotion.youkucard.http.get request
 * 
 * @author top auto create
 * @since 1.0, 2019.07.08
 */
public class PromotionYoukucardHttpGetRequest extends BaseTaobaoRequest<PromotionYoukucardHttpGetResponse> {
	
	

	/** 
	* 合作?方?生成的订单ID
	 */
	private String outOrderNo;

	/** 
	* 合作方公钥
	 */
	private String partnerKey;

	/** 
	* 会员卡活动ID
	 */
	private Long projectId;

	/** 
	* 签名
	 */
	private String signCode;

	/** 
	* 签名类型
	 */
	private String signType;

	/** 
	* 请求时间戳
	 */
	private String timeStamp;

	public void setOutOrderNo(String outOrderNo) {
		this.outOrderNo = outOrderNo;
	}

	public String getOutOrderNo() {
		return this.outOrderNo;
	}

	public void setPartnerKey(String partnerKey) {
		this.partnerKey = partnerKey;
	}

	public String getPartnerKey() {
		return this.partnerKey;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public Long getProjectId() {
		return this.projectId;
	}

	public void setSignCode(String signCode) {
		this.signCode = signCode;
	}

	public String getSignCode() {
		return this.signCode;
	}

	public void setSignType(String signType) {
		this.signType = signType;
	}

	public String getSignType() {
		return this.signType;
	}

	public void setTimeStamp(String timeStamp) {
		this.timeStamp = timeStamp;
	}

	public String getTimeStamp() {
		return this.timeStamp;
	}

	public String getApiMethodName() {
		return "taobao.promotion.youkucard.http.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("out_order_no", this.outOrderNo);
		txtParams.put("partner_key", this.partnerKey);
		txtParams.put("project_id", this.projectId);
		txtParams.put("sign_code", this.signCode);
		txtParams.put("sign_type", this.signType);
		txtParams.put("time_stamp", this.timeStamp);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionYoukucardHttpGetResponse> getResponseClass() {
		return PromotionYoukucardHttpGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(outOrderNo, "outOrderNo");
		RequestCheckUtils.checkNotEmpty(partnerKey, "partnerKey");
		RequestCheckUtils.checkNotEmpty(projectId, "projectId");
		RequestCheckUtils.checkNotEmpty(signCode, "signCode");
		RequestCheckUtils.checkNotEmpty(signType, "signType");
		RequestCheckUtils.checkNotEmpty(timeStamp, "timeStamp");
	}
	

}