package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotioncenterCouponExchangecodeGetResponse;

/**
 * TOP API: taobao.promotioncenter.coupon.exchangecode.get request
 * 
 * @author top auto create
 * @since 1.0, 2019.11.07
 */
public class PromotioncenterCouponExchangecodeGetRequest extends BaseTaobaoRequest<PromotioncenterCouponExchangecodeGetResponse> {
	
	

	/** 
	* 外部ID（请保证唯一）
	 */
	private String outCouponId;

	/** 
	* 外部类型
	 */
	private Long outCouponType;

	/** 
	* 券提供者ID
	 */
	private Long sellerId;

	/** 
	* 券活动ID（使用请咨询开发者）
	 */
	private Long tagId;

	/** 
	* 券ID
	 */
	private String uuid;

	public void setOutCouponId(String outCouponId) {
		this.outCouponId = outCouponId;
	}

	public String getOutCouponId() {
		return this.outCouponId;
	}

	public void setOutCouponType(Long outCouponType) {
		this.outCouponType = outCouponType;
	}

	public Long getOutCouponType() {
		return this.outCouponType;
	}

	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public Long getSellerId() {
		return this.sellerId;
	}

	public void setTagId(Long tagId) {
		this.tagId = tagId;
	}

	public Long getTagId() {
		return this.tagId;
	}

	public void setUuid(String uuid) {
		this.uuid = uuid;
	}

	public String getUuid() {
		return this.uuid;
	}

	public String getApiMethodName() {
		return "taobao.promotioncenter.coupon.exchangecode.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("out_coupon_id", this.outCouponId);
		txtParams.put("out_coupon_type", this.outCouponType);
		txtParams.put("seller_id", this.sellerId);
		txtParams.put("tag_id", this.tagId);
		txtParams.put("uuid", this.uuid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotioncenterCouponExchangecodeGetResponse> getResponseClass() {
		return PromotioncenterCouponExchangecodeGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(outCouponId, "outCouponId");
		RequestCheckUtils.checkNotEmpty(outCouponType, "outCouponType");
		RequestCheckUtils.checkNotEmpty(sellerId, "sellerId");
		RequestCheckUtils.checkNotEmpty(uuid, "uuid");
	}
	

}