package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.PromotionmiscMjsActivityListGetResponse;

/**
 * TOP API: taobao.promotionmisc.mjs.activity.list.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.05.23
 */
public class PromotionmiscMjsActivityListGetRequest extends BaseTaobaoRequest<PromotionmiscMjsActivityListGetResponse> {
	
	

	/** 
	* 活动类型： 1表示商品级别的活动；2表示店铺级别的活动。
	 */
	private Long activityType;

	/** 
	* 页码。
	 */
	private Long pageNo;

	/** 
	* 每页记录数，最大支持50 。
	 */
	private Long pageSize;

	public void setActivityType(Long activityType) {
		this.activityType = activityType;
	}

	public Long getActivityType() {
		return this.activityType;
	}

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}

	public Long getPageNo() {
		return this.pageNo;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public String getApiMethodName() {
		return "taobao.promotionmisc.mjs.activity.list.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_type", this.activityType);
		txtParams.put("page_no", this.pageNo);
		txtParams.put("page_size", this.pageSize);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<PromotionmiscMjsActivityListGetResponse> getResponseClass() {
		return PromotionmiscMjsActivityListGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityType, "activityType");
		RequestCheckUtils.checkNotEmpty(pageNo, "pageNo");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
	}
	

}