package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallBlackboxDrawGetResponse;

/**
 * TOP API: tmall.blackbox.draw.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallBlackboxDrawGetRequest extends BaseTaobaoRequest<TmallBlackboxDrawGetResponse> {
	
	

	/** 
	* 业务id
	 */
	private Long bizId;

	/** 
	* 微博uid
	 */
	private Long weiboUid;

	public void setBizId(Long bizId) {
		this.bizId = bizId;
	}

	public Long getBizId() {
		return this.bizId;
	}

	public void setWeiboUid(Long weiboUid) {
		this.weiboUid = weiboUid;
	}

	public Long getWeiboUid() {
		return this.weiboUid;
	}

	public String getApiMethodName() {
		return "tmall.blackbox.draw.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_id", this.bizId);
		txtParams.put("weibo_uid", this.weiboUid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallBlackboxDrawGetResponse> getResponseClass() {
		return TmallBlackboxDrawGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizId, "bizId");
		RequestCheckUtils.checkNotEmpty(weiboUid, "weiboUid");
	}
	

}