package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallHkTaxfreeItemSetResponse;

/**
 * TOP API: tmall.hk.taxfree.item.set request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallHkTaxfreeItemSetRequest extends BaseTaobaoRequest<TmallHkTaxfreeItemSetResponse> {
	
	

	/** 
	* 入参对象
	 */
	private String paramGsellerActivityRequest;

	public void setParamGsellerActivityRequest(String paramGsellerActivityRequest) {
		this.paramGsellerActivityRequest = paramGsellerActivityRequest;
	}

	public void setParamGsellerActivityRequest(GsellerActivityRequest paramGsellerActivityRequest) {
		this.paramGsellerActivityRequest = new JSONWriter(false,true).write(paramGsellerActivityRequest);
	}

	public String getParamGsellerActivityRequest() {
		return this.paramGsellerActivityRequest;
	}

	public String getApiMethodName() {
		return "tmall.hk.taxfree.item.set";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_gseller_activity_request", this.paramGsellerActivityRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallHkTaxfreeItemSetResponse> getResponseClass() {
		return TmallHkTaxfreeItemSetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 活动时间填充
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ExtraMap extends TaobaoObject {

	private static final long serialVersionUID = 8838857327467441893L;

	/**
		 * 包税活动的结束时间，要和activityId对应
		 */
		@ApiField("ump_begin_time")
		private Date umpBeginTime;
		/**
		 * 包税活动的开始时间，要和activityId对应
		 */
		@ApiField("ump_end_time")
		private Date umpEndTime;
	

	public Date getUmpBeginTime() {
			return this.umpBeginTime;
		}
		public void setUmpBeginTime(Date umpBeginTime) {
			this.umpBeginTime = umpBeginTime;
		}
		public Date getUmpEndTime() {
			return this.umpEndTime;
		}
		public void setUmpEndTime(Date umpEndTime) {
			this.umpEndTime = umpEndTime;
		}

}

	/**
 * 卖家维度对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TmpSeller extends TaobaoObject {

	private static final long serialVersionUID = 7619121796554376647L;

	/**
		 * 活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 包税商品列表
		 */
		@ApiListField("item_id_list")
		@ApiField("number")
		private List<Long> itemIdList;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public List<Long> getItemIdList() {
			return this.itemIdList;
		}
		public void setItemIdList(List<Long> itemIdList) {
			this.itemIdList = itemIdList;
		}

}

	/**
 * 入参对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class GsellerActivityRequest extends TaobaoObject {

	private static final long serialVersionUID = 2183671223161344553L;

	/**
		 * 活动id
		 */
		@ApiField("activity_id")
		private Long activityId;
		/**
		 * 活动名称
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 应用标识
		 */
		@ApiField("app_code")
		private String appCode;
		/**
		 * 商品类型
		 */
		@ApiField("event_enum")
		private String eventEnum;
		/**
		 * 活动时间填充
		 */
		@ApiField("extra_map")
		private ExtraMap extraMap;
		/**
		 * 卖家维度对象
		 */
		@ApiListField("seller_list")
		@ApiField("tmp_seller")
		private List<TmpSeller> sellerList;
		/**
		 * 类型
		 */
		@ApiField("type")
		private String type;
	

	public Long getActivityId() {
			return this.activityId;
		}
		public void setActivityId(Long activityId) {
			this.activityId = activityId;
		}
		public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public String getAppCode() {
			return this.appCode;
		}
		public void setAppCode(String appCode) {
			this.appCode = appCode;
		}
		public String getEventEnum() {
			return this.eventEnum;
		}
		public void setEventEnum(String eventEnum) {
			this.eventEnum = eventEnum;
		}
		public ExtraMap getExtraMap() {
			return this.extraMap;
		}
		public void setExtraMap(ExtraMap extraMap) {
			this.extraMap = extraMap;
		}
		public List<TmpSeller> getSellerList() {
			return this.sellerList;
		}
		public void setSellerList(List<TmpSeller> sellerList) {
			this.sellerList = sellerList;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}

}


}