package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallItempromotionActivityCreateResponse;

/**
 * TOP API: tmall.itempromotion.activity.create request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallItempromotionActivityCreateRequest extends BaseTaobaoRequest<TmallItempromotionActivityCreateResponse> {
	
	

	/** 
	* 应用来源信息
	 */
	private String appInfo;

	/** 
	* 入参DTO
	 */
	private String campaignDto;

	public void setAppInfo(String appInfo) {
		this.appInfo = appInfo;
	}

	public void setAppInfo(AppInfo appInfo) {
		this.appInfo = new JSONWriter(false,true).write(appInfo);
	}

	public String getAppInfo() {
		return this.appInfo;
	}

	public void setCampaignDto(String campaignDto) {
		this.campaignDto = campaignDto;
	}

	public void setCampaignDto(CampaignDTO campaignDto) {
		this.campaignDto = new JSONWriter(false,true).write(campaignDto);
	}

	public String getCampaignDto() {
		return this.campaignDto;
	}

	public String getApiMethodName() {
		return "tmall.itempromotion.activity.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("app_info", this.appInfo);
		txtParams.put("campaign_dto", this.campaignDto);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallItempromotionActivityCreateResponse> getResponseClass() {
		return TmallItempromotionActivityCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 入参DTO
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CampaignDTO extends TaobaoObject {

	private static final long serialVersionUID = 8395267445685518949L;

	/**
		 * 活动名称
		 */
		@ApiField("campaign_name")
		private String campaignName;
		/**
		 * 活动结束时间
		 */
		@ApiField("end_time")
		private Date endTime;
		/**
		 * 活动开始时间
		 */
		@ApiField("start_time")
		private Date startTime;
	

	public String getCampaignName() {
			return this.campaignName;
		}
		public void setCampaignName(String campaignName) {
			this.campaignName = campaignName;
		}
		public Date getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Date endTime) {
			this.endTime = endTime;
		}
		public Date getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Date startTime) {
			this.startTime = startTime;
		}

}

	/**
 * 应用来源信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AppInfo extends TaobaoObject {

	private static final long serialVersionUID = 5375574129861932625L;

	/**
		 * 应用名
		 */
		@ApiField("app_name")
		private String appName;
	

	public String getAppName() {
			return this.appName;
		}
		public void setAppName(String appName) {
			this.appName = appName;
		}

}


}