package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallItempromotionActivityDeleteResponse;

/**
 * TOP API: tmall.itempromotion.activity.delete request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallItempromotionActivityDeleteRequest extends BaseTaobaoRequest<TmallItempromotionActivityDeleteResponse> {
	
	

	/** 
	* 活动id
	 */
	private Long activityId;

	/** 
	* 来源信息
	 */
	private String appInfo;

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getActivityId() {
		return this.activityId;
	}

	public void setAppInfo(String appInfo) {
		this.appInfo = appInfo;
	}

	public void setAppInfo(AppInfo appInfo) {
		this.appInfo = new JSONWriter(false,true).write(appInfo);
	}

	public String getAppInfo() {
		return this.appInfo;
	}

	public String getApiMethodName() {
		return "tmall.itempromotion.activity.delete";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_id", this.activityId);
		txtParams.put("app_info", this.appInfo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallItempromotionActivityDeleteResponse> getResponseClass() {
		return TmallItempromotionActivityDeleteResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityId, "activityId");
	}
	
	/**
 * 来源信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AppInfo extends TaobaoObject {

	private static final long serialVersionUID = 6582227232485379445L;

	/**
		 * 应用名
		 */
		@ApiField("app_name")
		private String appName;
	

	public String getAppName() {
			return this.appName;
		}
		public void setAppName(String appName) {
			this.appName = appName;
		}

}


}