package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallItempromotionItemDeleteResponse;

/**
 * TOP API: tmall.itempromotion.item.delete request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallItempromotionItemDeleteRequest extends BaseTaobaoRequest<TmallItempromotionItemDeleteResponse> {
	
	

	/** 
	* 应用来源
	 */
	private String appInfo;

	/** 
	* 活动id
	 */
	private Long campaignId;

	/** 
	* 商品id
	 */
	private Long itemId;

	public void setAppInfo(String appInfo) {
		this.appInfo = appInfo;
	}

	public void setAppInfo(AppInfo appInfo) {
		this.appInfo = new JSONWriter(false,true).write(appInfo);
	}

	public String getAppInfo() {
		return this.appInfo;
	}

	public void setCampaignId(Long campaignId) {
		this.campaignId = campaignId;
	}

	public Long getCampaignId() {
		return this.campaignId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public String getApiMethodName() {
		return "tmall.itempromotion.item.delete";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("app_info", this.appInfo);
		txtParams.put("campaign_id", this.campaignId);
		txtParams.put("item_id", this.itemId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallItempromotionItemDeleteResponse> getResponseClass() {
		return TmallItempromotionItemDeleteResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(campaignId, "campaignId");
		RequestCheckUtils.checkNotEmpty(itemId, "itemId");
	}
	
	/**
 * 应用来源
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AppInfo extends TaobaoObject {

	private static final long serialVersionUID = 3871862689755153861L;

	/**
		 * 应用名
		 */
		@ApiField("app_name")
		private String appName;
	

	public String getAppName() {
			return this.appName;
		}
		public void setAppName(String appName) {
			this.appName = appName;
		}

}


}