package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallLuxuryMkActivityNewCreateResponse;

/**
 * TOP API: tmall.luxury.mk.activity.new.create request
 * 
 * @author top auto create
 * @since 1.0, 2021.08.31
 */
public class TmallLuxuryMkActivityNewCreateRequest extends BaseTaobaoRequest<TmallLuxuryMkActivityNewCreateResponse> {
	
	

	/** 
	* 活动对象
	 */
	private String activityDto;

	/** 
	* 应用来源信息
	 */
	private String appInfo;

	public void setActivityDto(String activityDto) {
		this.activityDto = activityDto;
	}

	public void setActivityDto(ActivityDTO activityDto) {
		this.activityDto = new JSONWriter(false,true).write(activityDto);
	}

	public String getActivityDto() {
		return this.activityDto;
	}

	public void setAppInfo(String appInfo) {
		this.appInfo = appInfo;
	}

	public void setAppInfo(AppInfo appInfo) {
		this.appInfo = new JSONWriter(false,true).write(appInfo);
	}

	public String getAppInfo() {
		return this.appInfo;
	}

	public String getApiMethodName() {
		return "tmall.luxury.mk.activity.new.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_dto", this.activityDto);
		txtParams.put("app_info", this.appInfo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallLuxuryMkActivityNewCreateResponse> getResponseClass() {
		return TmallLuxuryMkActivityNewCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 活动对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivityDTO extends TaobaoObject {

	private static final long serialVersionUID = 7596428441862447548L;

	/**
		 * 活动名称
		 */
		@ApiField("activity_name")
		private String activityName;
		/**
		 * 活动类型枚举 1:定向神器
		 */
		@ApiField("activity_type")
		private Long activityType;
		/**
		 * 折扣方式 1:售卖价 2:打折 3:减钱
		 */
		@ApiField("discount_type")
		private Long discountType;
		/**
		 * 活动结束时间
		 */
		@ApiField("end_time")
		private Date endTime;
		/**
		 * 活动开始时间
		 */
		@ApiField("start_time")
		private Date startTime;
	

	public String getActivityName() {
			return this.activityName;
		}
		public void setActivityName(String activityName) {
			this.activityName = activityName;
		}
		public Long getActivityType() {
			return this.activityType;
		}
		public void setActivityType(Long activityType) {
			this.activityType = activityType;
		}
		public Long getDiscountType() {
			return this.discountType;
		}
		public void setDiscountType(Long discountType) {
			this.discountType = discountType;
		}
		public Date getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Date endTime) {
			this.endTime = endTime;
		}
		public Date getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Date startTime) {
			this.startTime = startTime;
		}

}

	/**
 * 应用来源信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AppInfo extends TaobaoObject {

	private static final long serialVersionUID = 3272269952843591113L;

	/**
		 * 应用名
		 */
		@ApiField("app_name")
		private String appName;
	

	public String getAppName() {
			return this.appName;
		}
		public void setAppName(String appName) {
			this.appName = appName;
		}

}


}