package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallOverseaPromotionCouponSendResponse;

/**
 * TOP API: tmall.oversea.promotion.coupon.send request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallOverseaPromotionCouponSendRequest extends BaseTaobaoRequest<TmallOverseaPromotionCouponSendResponse> {
	
	

	/** 
	* 权益发放入参
	 */
	private String paramBenefitSendRequest;

	public void setParamBenefitSendRequest(String paramBenefitSendRequest) {
		this.paramBenefitSendRequest = paramBenefitSendRequest;
	}

	public void setParamBenefitSendRequest(BenefitSendRequest paramBenefitSendRequest) {
		this.paramBenefitSendRequest = new JSONWriter(false,true).write(paramBenefitSendRequest);
	}

	public String getParamBenefitSendRequest() {
		return this.paramBenefitSendRequest;
	}

	public String getApiMethodName() {
		return "tmall.oversea.promotion.coupon.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_benefit_send_request", this.paramBenefitSendRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallOverseaPromotionCouponSendResponse> getResponseClass() {
		return TmallOverseaPromotionCouponSendResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 权益发放入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BenefitSendRequest extends TaobaoObject {

	private static final long serialVersionUID = 8373214638589512253L;

	/**
		 * 调用方应用名称
		 */
		@ApiField("app_name")
		private String appName;
		/**
		 * 安全码
		 */
		@ApiField("asac")
		private String asac;
		/**
		 * 投放code
		 */
		@ApiField("code")
		private String code;
		/**
		 * 幂等id
		 */
		@ApiField("idempotent_id")
		private String idempotentId;
		/**
		 * 用户id
		 */
		@ApiField("user_id")
		private String userId;
		/**
		 * 用户类型
		 */
		@ApiField("user_type")
		private String userType;
	

	public String getAppName() {
			return this.appName;
		}
		public void setAppName(String appName) {
			this.appName = appName;
		}
		public String getAsac() {
			return this.asac;
		}
		public void setAsac(String asac) {
			this.asac = asac;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getIdempotentId() {
			return this.idempotentId;
		}
		public void setIdempotentId(String idempotentId) {
			this.idempotentId = idempotentId;
		}
		public String getUserId() {
			return this.userId;
		}
		public void setUserId(String userId) {
			this.userId = userId;
		}
		public String getUserType() {
			return this.userType;
		}
		public void setUserType(String userType) {
			this.userType = userType;
		}

}


}