package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallPromotagTagRemovetagResponse;

/**
 * TOP API: tmall.promotag.tag.removetag request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class TmallPromotagTagRemovetagRequest extends BaseTaobaoRequest<TmallPromotagTagRemovetagResponse> {
	
	

	/** 
	* 需要删除的标签id
	 */
	private Long tagId;

	public void setTagId(Long tagId) {
		this.tagId = tagId;
	}

	public Long getTagId() {
		return this.tagId;
	}

	public String getApiMethodName() {
		return "tmall.promotag.tag.removetag";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("tag_id", this.tagId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallPromotagTagRemovetagResponse> getResponseClass() {
		return TmallPromotagTagRemovetagResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(tagId, "tagId");
	}
	

}