package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpActivitiesGetResponse;

/**
 * TOP API: taobao.ump.activities.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class UmpActivitiesGetRequest extends BaseTaobaoRequest<UmpActivitiesGetResponse> {
	
	

	/** 
	* 分页的页码
	 */
	private Long pageNo;

	/** 
	* 每页的最大条数
	 */
	private Long pageSize;

	/** 
	* 工具id
	 */
	private Long toolId;

	public void setPageNo(Long pageNo) {
		this.pageNo = pageNo;
	}

	public Long getPageNo() {
		return this.pageNo;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setToolId(Long toolId) {
		this.toolId = toolId;
	}

	public Long getToolId() {
		return this.toolId;
	}

	public String getApiMethodName() {
		return "taobao.ump.activities.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("page_no", this.pageNo);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("tool_id", this.toolId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpActivitiesGetResponse> getResponseClass() {
		return UmpActivitiesGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(pageNo, "pageNo");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(toolId, "toolId");
	}
	

}