package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpActivityAddResponse;

/**
 * TOP API: taobao.ump.activity.add request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class UmpActivityAddRequest extends BaseTaobaoRequest<UmpActivityAddResponse> {
	
	

	/** 
	* 活动内容，通过ump sdk里面的MarkeitngTool来生成，name必须属于“营销标签词库”——https:huodong.m.taobao.comapidatav25fe5e737d3314fa2973297f86f7bff3a.js?file=5fe5e737d3314fa2973297f86f7bff3a.js中的word值中的一种。
	 */
	private String content;

	/** 
	* 工具id
	 */
	private Long toolId;

	public void setContent(String content) {
		this.content = content;
	}

	public String getContent() {
		return this.content;
	}

	public void setToolId(Long toolId) {
		this.toolId = toolId;
	}

	public Long getToolId() {
		return this.toolId;
	}

	public String getApiMethodName() {
		return "taobao.ump.activity.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("content", this.content);
		txtParams.put("tool_id", this.toolId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpActivityAddResponse> getResponseClass() {
		return UmpActivityAddResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(content, "content");
		RequestCheckUtils.checkNotEmpty(toolId, "toolId");
	}
	

}