package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpDetailAddResponse;

/**
 * TOP API: taobao.ump.detail.add request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class UmpDetailAddRequest extends BaseTaobaoRequest<UmpDetailAddResponse> {
	
	

	/** 
	* 增加工具详情
	 */
	private Long actId;

	/** 
	* 活动详情内容，json格式，可以通过ump sdk中的MarketingTool来进行处理
	 */
	private String content;

	public void setActId(Long actId) {
		this.actId = actId;
	}

	public Long getActId() {
		return this.actId;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getContent() {
		return this.content;
	}

	public String getApiMethodName() {
		return "taobao.ump.detail.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("act_id", this.actId);
		txtParams.put("content", this.content);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpDetailAddResponse> getResponseClass() {
		return UmpDetailAddResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(actId, "actId");
		RequestCheckUtils.checkNotEmpty(content, "content");
	}
	

}