package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpDetailGetResponse;

/**
 * TOP API: taobao.ump.detail.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class UmpDetailGetRequest extends BaseTaobaoRequest<UmpDetailGetResponse> {
	
	

	/** 
	* 活动详情的id
	 */
	private Long detailId;

	public void setDetailId(Long detailId) {
		this.detailId = detailId;
	}

	public Long getDetailId() {
		return this.detailId;
	}

	public String getApiMethodName() {
		return "taobao.ump.detail.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("detail_id", this.detailId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpDetailGetResponse> getResponseClass() {
		return UmpDetailGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(detailId, "detailId");
	}
	

}