package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpDetailListAddResponse;

/**
 * TOP API: taobao.ump.detail.list.add request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class UmpDetailListAddRequest extends BaseTaobaoRequest<UmpDetailListAddResponse> {
	
	

	/** 
	* 营销活动id。
	 */
	private Long actId;

	/** 
	* 营销详情的列表。此列表由detail的json字符串组成。最多插入为10个。
	 */
	private String details;

	public void setActId(Long actId) {
		this.actId = actId;
	}

	public Long getActId() {
		return this.actId;
	}

	public void setDetails(String details) {
		this.details = details;
	}

	public String getDetails() {
		return this.details;
	}

	public String getApiMethodName() {
		return "taobao.ump.detail.list.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("act_id", this.actId);
		txtParams.put("details", this.details);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpDetailListAddResponse> getResponseClass() {
		return UmpDetailListAddResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(actId, "actId");
		RequestCheckUtils.checkNotEmpty(details, "details");
	}
	

}