package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpDetailUpdateResponse;

/**
 * TOP API: taobao.ump.detail.update request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class UmpDetailUpdateRequest extends BaseTaobaoRequest<UmpDetailUpdateResponse> {
	
	

	/** 
	* 活动详情内容，可以通过ump sdk中的MarketingTool来生成这个内容
	 */
	private String content;

	/** 
	* 活动详情id
	 */
	private Long detailId;

	public void setContent(String content) {
		this.content = content;
	}

	public String getContent() {
		return this.content;
	}

	public void setDetailId(Long detailId) {
		this.detailId = detailId;
	}

	public Long getDetailId() {
		return this.detailId;
	}

	public String getApiMethodName() {
		return "taobao.ump.detail.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("content", this.content);
		txtParams.put("detail_id", this.detailId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpDetailUpdateResponse> getResponseClass() {
		return UmpDetailUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(content, "content");
		RequestCheckUtils.checkNotEmpty(detailId, "detailId");
	}
	

}