package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpMbbGetbycodeResponse;

/**
 * TOP API: taobao.ump.mbb.getbycode request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.17
 */
public class UmpMbbGetbycodeRequest extends BaseTaobaoRequest<UmpMbbGetbycodeResponse> {
	
	

	/** 
	* 营销积木块code
	 */
	private String code;

	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return this.code;
	}

	public String getApiMethodName() {
		return "taobao.ump.mbb.getbycode";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("code", this.code);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpMbbGetbycodeResponse> getResponseClass() {
		return UmpMbbGetbycodeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(code, "code");
	}
	

}