package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpMbbsGetResponse;

/**
 * TOP API: taobao.ump.mbbs.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.17
 */
public class UmpMbbsGetRequest extends BaseTaobaoRequest<UmpMbbsGetResponse> {
	
	

	/** 
	* 积木块类型。如果该字段为空表示查出所有类型的
现在有且仅有如下几种：resource,condition,action,target
	 */
	private String type;

	public void setType(String type) {
		this.type = type;
	}

	public String getType() {
		return this.type;
	}

	public String getApiMethodName() {
		return "taobao.ump.mbbs.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("type", this.type);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpMbbsGetResponse> getResponseClass() {
		return UmpMbbsGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}