package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpMbbsListGetResponse;

/**
 * TOP API: taobao.ump.mbbs.list.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.17
 */
public class UmpMbbsListGetRequest extends BaseTaobaoRequest<UmpMbbsListGetResponse> {
	
	

	/** 
	* 营销积木块id组成的字符串。
	 */
	private Long ids;

	public void setIds(Long ids) {
		this.ids = ids;
	}

	public Long getIds() {
		return this.ids;
	}

	public String getApiMethodName() {
		return "taobao.ump.mbbs.list.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("ids", this.ids);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpMbbsListGetResponse> getResponseClass() {
		return UmpMbbsListGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(ids, "ids");
	}
	

}