package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UmpToolGetResponse;

/**
 * TOP API: taobao.ump.tool.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.17
 */
public class UmpToolGetRequest extends BaseTaobaoRequest<UmpToolGetResponse> {
	
	

	/** 
	* 工具的id
	 */
	private Long toolId;

	public void setToolId(Long toolId) {
		this.toolId = toolId;
	}

	public Long getToolId() {
		return this.toolId;
	}

	public String getApiMethodName() {
		return "taobao.ump.tool.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("tool_id", this.toolId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UmpToolGetResponse> getResponseClass() {
		return UmpToolGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(toolId, "toolId");
	}
	

}