package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.lafite.seller.activity.list response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaLafiteSellerActivityListResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1689582513616417598L;

	/** 
	 * 接口返回结果
	 */
	@ApiField("result")
	private Result result;


	public void setResult(Result result) {
		this.result = result;
	}
	public Result getResult( ) {
		return this.result;
	}
	
	/**
 * 权益列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BenefitDto extends TaobaoObject {

	private static final long serialVersionUID = 8772835957344761999L;

	/**
		 * 发放量
		 */
		@ApiField("bestow")
		private Long bestow;
		/**
		 * 权益code
		 */
		@ApiField("code")
		private String code;
		/**
		 * 权益描述
		 */
		@ApiField("description")
		private String description;
		/**
		 * 权益发放结束时间
		 */
		@ApiField("end_date")
		private Date endDate;
		/**
		 * 扩展字段
		 */
		@ApiField("feature")
		private String feature;
		/**
		 * 权益名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 权益发放开始时间
		 */
		@ApiField("start_date")
		private Date startDate;
		/**
		 * 权益状态，online为上线，offline为下线，invalid为失效
		 */
		@ApiField("status")
		private String status;
		/**
		 * 总库存
		 */
		@ApiField("total")
		private Long total;
		/**
		 * 权益类型
		 */
		@ApiField("type")
		private String type;
	

	public Long getBestow() {
			return this.bestow;
		}
		public void setBestow(Long bestow) {
			this.bestow = bestow;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public Date getEndDate() {
			return this.endDate;
		}
		public void setEndDate(Date endDate) {
			this.endDate = endDate;
		}
		public String getFeature() {
			return this.feature;
		}
		public void setFeature(String feature) {
			this.feature = feature;
		}
		public void setFeatureString(String feature) {
			this.feature = feature;
		}
		
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public Date getStartDate() {
			return this.startDate;
		}
		public void setStartDate(Date startDate) {
			this.startDate = startDate;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public Long getTotal() {
			return this.total;
		}
		public void setTotal(Long total) {
			this.total = total;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}

}

	/**
 * 返回的活动列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivityDto extends TaobaoObject {

	private static final long serialVersionUID = 3759539751153497318L;

	/**
		 * 权益列表
		 */
		@ApiListField("benefit_list")
		@ApiField("benefit_dto")
		private List<BenefitDto> benefitList;
		/**
		 * 渠道code
		 */
		@ApiField("channel_code")
		private String channelCode;
		/**
		 * 活动结束时间
		 */
		@ApiField("end_time")
		private Date endTime;
		/**
		 * 扩展字段
		 */
		@ApiField("feature")
		private String feature;
		/**
		 * 活动名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 业务来源
		 */
		@ApiField("source")
		private String source;
		/**
		 * 活动开始时间
		 */
		@ApiField("start_time")
		private Date startTime;
		/**
		 * 活动状态，EFFECTIVE为生效，OFFLINE为下线
		 */
		@ApiField("status")
		private String status;
		/**
		 * 投放计划code
		 */
		@ApiField("strategy_code")
		private String strategyCode;
	

	public List<BenefitDto> getBenefitList() {
			return this.benefitList;
		}
		public void setBenefitList(List<BenefitDto> benefitList) {
			this.benefitList = benefitList;
		}
		public String getChannelCode() {
			return this.channelCode;
		}
		public void setChannelCode(String channelCode) {
			this.channelCode = channelCode;
		}
		public Date getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Date endTime) {
			this.endTime = endTime;
		}
		public String getFeature() {
			return this.feature;
		}
		public void setFeature(String feature) {
			this.feature = feature;
		}
		public void setFeatureString(String feature) {
			this.feature = feature;
		}
		
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getSource() {
			return this.source;
		}
		public void setSource(String source) {
			this.source = source;
		}
		public Date getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Date startTime) {
			this.startTime = startTime;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getStrategyCode() {
			return this.strategyCode;
		}
		public void setStrategyCode(String strategyCode) {
			this.strategyCode = strategyCode;
		}

}

	/**
 * 接口返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Page extends TaobaoObject {

	private static final long serialVersionUID = 2497712376543775636L;

	/**
		 * 返回的活动列表
		 */
		@ApiListField("activity_list")
		@ApiField("activity_dto")
		private List<ActivityDto> activityList;
		/**
		 * 当前页
		 */
		@ApiField("current_page")
		private Long currentPage;
		/**
		 * 每页的记录数
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 总记录数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<ActivityDto> getActivityList() {
			return this.activityList;
		}
		public void setActivityList(List<ActivityDto> activityList) {
			this.activityList = activityList;
		}
		public Long getCurrentPage() {
			return this.currentPage;
		}
		public void setCurrentPage(Long currentPage) {
			this.currentPage = currentPage;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}

	/**
 * 接口返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 5653464325287675112L;

	/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 错误描述
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 接口返回结果
		 */
		@ApiField("page_data")
		private Page pageData;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Page getPageData() {
			return this.pageData;
		}
		public void setPageData(Page pageData) {
			this.pageData = pageData;
		}

}



}
