package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.latour.strategy.show response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaLatourStrategyShowResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2139713769433161866L;

	/** 
	 * 返回结果
	 */
	@ApiField("result")
	private Result result;


	public void setResult(Result result) {
		this.result = result;
	}
	public Result getResult( ) {
		return this.result;
	}
	
	/**
 * 投放计划规则
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ShowRuleDto extends TaobaoObject {

	private static final long serialVersionUID = 5397895766679831937L;

	/**
		 * 规则扩展信息
		 */
		@ApiField("feature")
		private String feature;
		/**
		 * 规则是否通过
		 */
		@ApiField("passed")
		private Boolean passed;
		/**
		 * 规则类型
		 */
		@ApiField("type")
		private String type;
	

	public String getFeature() {
			return this.feature;
		}
		public void setFeature(String feature) {
			this.feature = feature;
		}
		public void setFeatureString(String feature) {
			this.feature = feature;
		}
		
		public Boolean getPassed() {
			return this.passed;
		}
		public void setPassed(Boolean passed) {
			this.passed = passed;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}

}

	/**
 * 投放计划维度核销数据
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ShowBenefitInstanceDTO extends TaobaoObject {

	private static final long serialVersionUID = 1899983969144591561L;

	/**
		 * 权益code
		 */
		@ApiField("benefit_code")
		private String benefitCode;
		/**
		 * 权益类型
		 */
		@ApiField("benefit_type")
		private String benefitType;
		/**
		 * 中奖记录ID
		 */
		@ApiField("record_id")
		private Long recordId;
	

	public String getBenefitCode() {
			return this.benefitCode;
		}
		public void setBenefitCode(String benefitCode) {
			this.benefitCode = benefitCode;
		}
		public String getBenefitType() {
			return this.benefitType;
		}
		public void setBenefitType(String benefitType) {
			this.benefitType = benefitType;
		}
		public Long getRecordId() {
			return this.recordId;
		}
		public void setRecordId(Long recordId) {
			this.recordId = recordId;
		}

}

	/**
 * 投放计划
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ShowStrategyDto extends TaobaoObject {

	private static final long serialVersionUID = 1144554335554675968L;

	/**
		 * 算法容灾结果
		 */
		@ApiField("algorithm_failover")
		private Boolean algorithmFailover;
		/**
		 * 是否投放计划所有规则通过
		 */
		@ApiField("all_rule_passed")
		private Boolean allRulePassed;
		/**
		 * 投放计划安全码
		 */
		@ApiField("asac")
		private String asac;
		/**
		 * 投放计划code
		 */
		@ApiField("code")
		private String code;
		/**
		 * 投放模式
		 */
		@ApiField("mode")
		private String mode;
		/**
		 * 投放计划维度核销数据
		 */
		@ApiListField("show_benefit_instances")
		@ApiField("show_benefit_instance_d_t_o")
		private List<ShowBenefitInstanceDTO> showBenefitInstances;
		/**
		 * 投放计划规则
		 */
		@ApiListField("show_rules")
		@ApiField("show_rule_dto")
		private List<ShowRuleDto> showRules;
	

	public Boolean getAlgorithmFailover() {
			return this.algorithmFailover;
		}
		public void setAlgorithmFailover(Boolean algorithmFailover) {
			this.algorithmFailover = algorithmFailover;
		}
		public Boolean getAllRulePassed() {
			return this.allRulePassed;
		}
		public void setAllRulePassed(Boolean allRulePassed) {
			this.allRulePassed = allRulePassed;
		}
		public String getAsac() {
			return this.asac;
		}
		public void setAsac(String asac) {
			this.asac = asac;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getMode() {
			return this.mode;
		}
		public void setMode(String mode) {
			this.mode = mode;
		}
		public List<ShowBenefitInstanceDTO> getShowBenefitInstances() {
			return this.showBenefitInstances;
		}
		public void setShowBenefitInstances(List<ShowBenefitInstanceDTO> showBenefitInstances) {
			this.showBenefitInstances = showBenefitInstances;
		}
		public List<ShowRuleDto> getShowRules() {
			return this.showRules;
		}
		public void setShowRules(List<ShowRuleDto> showRules) {
			this.showRules = showRules;
		}

}

	/**
 * 权益列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ShowBenefitDto extends TaobaoObject {

	private static final long serialVersionUID = 2752319323125144334L;

	/**
		 * 权益面额
		 */
		@ApiField("amount")
		private Long amount;
		/**
		 * 面额单位
		 */
		@ApiField("amount_unit")
		private String amountUnit;
		/**
		 * 权益安全码
		 */
		@ApiField("asac")
		private String asac;
		/**
		 * 权益是否可领
		 */
		@ApiField("can_win")
		private Boolean canWin;
		/**
		 * 权益code
		 */
		@ApiField("code")
		private String code;
		/**
		 * 展示面额
		 */
		@ApiField("display_amount")
		private String displayAmount;
		/**
		 * 权益展示面额单位
		 */
		@ApiField("display_amount_unit")
		private String displayAmountUnit;
		/**
		 * 展示门槛
		 */
		@ApiField("display_start_fee")
		private String displayStartFee;
		/**
		 * 绝对使用时间结束
		 */
		@ApiField("effective_end")
		private Date effectiveEnd;
		/**
		 * 相对使用时间长度
		 */
		@ApiField("effective_interval")
		private Long effectiveInterval;
		/**
		 * 绝对使用时间开始
		 */
		@ApiField("effective_start")
		private Date effectiveStart;
		/**
		 * 使用时间类型
		 */
		@ApiField("effective_time_mode")
		private String effectiveTimeMode;
		/**
		 * 加密动态面额参数
		 */
		@ApiField("encrypted_dynamic_info")
		private String encryptedDynamicInfo;
		/**
		 * 权益发放结束时间
		 */
		@ApiField("end_date")
		private Date endDate;
		/**
		 * 权益扩展信息
		 */
		@ApiField("feature")
		private String feature;
		/**
		 * 是否已领
		 */
		@ApiField("had_win")
		private Boolean hadWin;
		/**
		 * 是否有库存
		 */
		@ApiField("has_inventory")
		private Boolean hasInventory;
		/**
		 * 相对使用时间类型
		 */
		@ApiField("interval_time_unit")
		private String intervalTimeUnit;
		/**
		 * 素材
		 */
		@ApiField("material")
		private String material;
		/**
		 * 权益生命周期
		 */
		@ApiField("send_life_cycle_state")
		private String sendLifeCycleState;
		/**
		 * 权益发放类型
		 */
		@ApiField("send_mode")
		private String sendMode;
		/**
		 * 权益维度核销数据
		 */
		@ApiListField("show_benefit_instances")
		@ApiField("show_benefit_instance_d_t_o")
		private List<ShowBenefitInstanceDTO> showBenefitInstances;
		/**
		 * 权益规则列表
		 */
		@ApiListField("show_rules")
		@ApiField("show_rule_dto")
		private List<ShowRuleDto> showRules;
		/**
		 * 发放开始时间
		 */
		@ApiField("start_date")
		private Date startDate;
		/**
		 * 门槛
		 */
		@ApiField("start_fee")
		private Long startFee;
		/**
		 * 是否测试权益
		 */
		@ApiField("test")
		private Boolean test;
		/**
		 * 权益标题
		 */
		@ApiField("title")
		private String title;
		/**
		 * 权益类型
		 */
		@ApiField("type")
		private String type;
		/**
		 * 权益类型
		 */
		@ApiField("type_desc")
		private String typeDesc;
	

	public Long getAmount() {
			return this.amount;
		}
		public void setAmount(Long amount) {
			this.amount = amount;
		}
		public String getAmountUnit() {
			return this.amountUnit;
		}
		public void setAmountUnit(String amountUnit) {
			this.amountUnit = amountUnit;
		}
		public String getAsac() {
			return this.asac;
		}
		public void setAsac(String asac) {
			this.asac = asac;
		}
		public Boolean getCanWin() {
			return this.canWin;
		}
		public void setCanWin(Boolean canWin) {
			this.canWin = canWin;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getDisplayAmount() {
			return this.displayAmount;
		}
		public void setDisplayAmount(String displayAmount) {
			this.displayAmount = displayAmount;
		}
		public String getDisplayAmountUnit() {
			return this.displayAmountUnit;
		}
		public void setDisplayAmountUnit(String displayAmountUnit) {
			this.displayAmountUnit = displayAmountUnit;
		}
		public String getDisplayStartFee() {
			return this.displayStartFee;
		}
		public void setDisplayStartFee(String displayStartFee) {
			this.displayStartFee = displayStartFee;
		}
		public Date getEffectiveEnd() {
			return this.effectiveEnd;
		}
		public void setEffectiveEnd(Date effectiveEnd) {
			this.effectiveEnd = effectiveEnd;
		}
		public Long getEffectiveInterval() {
			return this.effectiveInterval;
		}
		public void setEffectiveInterval(Long effectiveInterval) {
			this.effectiveInterval = effectiveInterval;
		}
		public Date getEffectiveStart() {
			return this.effectiveStart;
		}
		public void setEffectiveStart(Date effectiveStart) {
			this.effectiveStart = effectiveStart;
		}
		public String getEffectiveTimeMode() {
			return this.effectiveTimeMode;
		}
		public void setEffectiveTimeMode(String effectiveTimeMode) {
			this.effectiveTimeMode = effectiveTimeMode;
		}
		public String getEncryptedDynamicInfo() {
			return this.encryptedDynamicInfo;
		}
		public void setEncryptedDynamicInfo(String encryptedDynamicInfo) {
			this.encryptedDynamicInfo = encryptedDynamicInfo;
		}
		public Date getEndDate() {
			return this.endDate;
		}
		public void setEndDate(Date endDate) {
			this.endDate = endDate;
		}
		public String getFeature() {
			return this.feature;
		}
		public void setFeature(String feature) {
			this.feature = feature;
		}
		public void setFeatureString(String feature) {
			this.feature = feature;
		}
		
		public Boolean getHadWin() {
			return this.hadWin;
		}
		public void setHadWin(Boolean hadWin) {
			this.hadWin = hadWin;
		}
		public Boolean getHasInventory() {
			return this.hasInventory;
		}
		public void setHasInventory(Boolean hasInventory) {
			this.hasInventory = hasInventory;
		}
		public String getIntervalTimeUnit() {
			return this.intervalTimeUnit;
		}
		public void setIntervalTimeUnit(String intervalTimeUnit) {
			this.intervalTimeUnit = intervalTimeUnit;
		}
		public String getMaterial() {
			return this.material;
		}
		public void setMaterial(String material) {
			this.material = material;
		}
		public void setMaterialString(String material) {
			this.material = material;
		}
		
		public String getSendLifeCycleState() {
			return this.sendLifeCycleState;
		}
		public void setSendLifeCycleState(String sendLifeCycleState) {
			this.sendLifeCycleState = sendLifeCycleState;
		}
		public String getSendMode() {
			return this.sendMode;
		}
		public void setSendMode(String sendMode) {
			this.sendMode = sendMode;
		}
		public List<ShowBenefitInstanceDTO> getShowBenefitInstances() {
			return this.showBenefitInstances;
		}
		public void setShowBenefitInstances(List<ShowBenefitInstanceDTO> showBenefitInstances) {
			this.showBenefitInstances = showBenefitInstances;
		}
		public List<ShowRuleDto> getShowRules() {
			return this.showRules;
		}
		public void setShowRules(List<ShowRuleDto> showRules) {
			this.showRules = showRules;
		}
		public Date getStartDate() {
			return this.startDate;
		}
		public void setStartDate(Date startDate) {
			this.startDate = startDate;
		}
		public Long getStartFee() {
			return this.startFee;
		}
		public void setStartFee(Long startFee) {
			this.startFee = startFee;
		}
		public Boolean getTest() {
			return this.test;
		}
		public void setTest(Boolean test) {
			this.test = test;
		}
		public String getTitle() {
			return this.title;
		}
		public void setTitle(String title) {
			this.title = title;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}
		public String getTypeDesc() {
			return this.typeDesc;
		}
		public void setTypeDesc(String typeDesc) {
			this.typeDesc = typeDesc;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StrategyShowResultDto extends TaobaoObject {

	private static final long serialVersionUID = 7619586585736925554L;

	/**
		 * 当前页
		 */
		@ApiField("current_page")
		private Long currentPage;
		/**
		 * 扩展参数
		 */
		@ApiField("extra_data")
		private String extraData;
		/**
		 * 是否有下一页
		 */
		@ApiField("has_next_page")
		private Boolean hasNextPage;
		/**
		 * 权益列表
		 */
		@ApiListField("show_benefits")
		@ApiField("show_benefit_dto")
		private List<ShowBenefitDto> showBenefits;
		/**
		 * 投放计划
		 */
		@ApiField("show_strategy")
		private ShowStrategyDto showStrategy;
		/**
		 * 追踪信息
		 */
		@ApiField("tracking_data")
		private String trackingData;
	

	public Long getCurrentPage() {
			return this.currentPage;
		}
		public void setCurrentPage(Long currentPage) {
			this.currentPage = currentPage;
		}
		public String getExtraData() {
			return this.extraData;
		}
		public void setExtraData(String extraData) {
			this.extraData = extraData;
		}
		public void setExtraDataString(String extraData) {
			this.extraData = extraData;
		}
		
		public Boolean getHasNextPage() {
			return this.hasNextPage;
		}
		public void setHasNextPage(Boolean hasNextPage) {
			this.hasNextPage = hasNextPage;
		}
		public List<ShowBenefitDto> getShowBenefits() {
			return this.showBenefits;
		}
		public void setShowBenefits(List<ShowBenefitDto> showBenefits) {
			this.showBenefits = showBenefits;
		}
		public ShowStrategyDto getShowStrategy() {
			return this.showStrategy;
		}
		public void setShowStrategy(ShowStrategyDto showStrategy) {
			this.showStrategy = showStrategy;
		}
		public String getTrackingData() {
			return this.trackingData;
		}
		public void setTrackingData(String trackingData) {
			this.trackingData = trackingData;
		}
		public void setTrackingDataString(String trackingData) {
			this.trackingData = trackingData;
		}
		

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 3436437738656483113L;

	/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 返回结果
		 */
		@ApiField("data")
		private StrategyShowResultDto data;
		/**
		 * 错误描述
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public StrategyShowResultDto getData() {
			return this.data;
		}
		public void setData(StrategyShowResultDto data) {
			this.data = data;
		}
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
