package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.latour.winrecord.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaLatourWinrecordQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6485115358413596394L;

	/** 
	 * 返回结果
	 */
	@ApiField("result")
	private Page result;


	public void setResult(Page result) {
		this.result = result;
	}
	public Page getResult( ) {
		return this.result;
	}
	
	/**
 * 用户
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class User extends TaobaoObject {

	private static final long serialVersionUID = 1598779425928962517L;

	/**
		 * 用户昵称
		 */
		@ApiField("user_nick")
		private String userNick;
		/**
		 * 用户类型
		 */
		@ApiField("user_type")
		private String userType;
	

	public String getUserNick() {
			return this.userNick;
		}
		public void setUserNick(String userNick) {
			this.userNick = userNick;
		}
		public String getUserType() {
			return this.userType;
		}
		public void setUserType(String userType) {
			this.userType = userType;
		}

}

	/**
 * 扩展字段
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Feature extends TaobaoObject {

	private static final long serialVersionUID = 6477823585669332492L;

	/**
		 * 面额
		 */
		@ApiField("amount")
		private String amount;
		/**
		 * 面额单位
		 */
		@ApiField("amount_unit")
		private String amountUnit;
		/**
		 * 展示面额
		 */
		@ApiField("display_amount")
		private String displayAmount;
		/**
		 * 展示面额单位
		 */
		@ApiField("display_amount_unit")
		private String displayAmountUnit;
		/**
		 * 暂时门槛
		 */
		@ApiField("display_start_fee")
		private String displayStartFee;
		/**
		 * 绝对生效时间结束
		 */
		@ApiField("effective_end")
		private String effectiveEnd;
		/**
		 * 相对生效时间间隔
		 */
		@ApiField("effective_interval")
		private String effectiveInterval;
		/**
		 * 绝对生效时间开始
		 */
		@ApiField("effective_start")
		private String effectiveStart;
		/**
		 * 生效时间模式
		 */
		@ApiField("effective_time_mode")
		private String effectiveTimeMode;
		/**
		 * 相对生效时间单位
		 */
		@ApiField("interval_time_unit")
		private String intervalTimeUnit;
		/**
		 * 门槛
		 */
		@ApiField("start_fee")
		private String startFee;
	

	public String getAmount() {
			return this.amount;
		}
		public void setAmount(String amount) {
			this.amount = amount;
		}
		public String getAmountUnit() {
			return this.amountUnit;
		}
		public void setAmountUnit(String amountUnit) {
			this.amountUnit = amountUnit;
		}
		public String getDisplayAmount() {
			return this.displayAmount;
		}
		public void setDisplayAmount(String displayAmount) {
			this.displayAmount = displayAmount;
		}
		public String getDisplayAmountUnit() {
			return this.displayAmountUnit;
		}
		public void setDisplayAmountUnit(String displayAmountUnit) {
			this.displayAmountUnit = displayAmountUnit;
		}
		public String getDisplayStartFee() {
			return this.displayStartFee;
		}
		public void setDisplayStartFee(String displayStartFee) {
			this.displayStartFee = displayStartFee;
		}
		public String getEffectiveEnd() {
			return this.effectiveEnd;
		}
		public void setEffectiveEnd(String effectiveEnd) {
			this.effectiveEnd = effectiveEnd;
		}
		public String getEffectiveInterval() {
			return this.effectiveInterval;
		}
		public void setEffectiveInterval(String effectiveInterval) {
			this.effectiveInterval = effectiveInterval;
		}
		public String getEffectiveStart() {
			return this.effectiveStart;
		}
		public void setEffectiveStart(String effectiveStart) {
			this.effectiveStart = effectiveStart;
		}
		public String getEffectiveTimeMode() {
			return this.effectiveTimeMode;
		}
		public void setEffectiveTimeMode(String effectiveTimeMode) {
			this.effectiveTimeMode = effectiveTimeMode;
		}
		public String getIntervalTimeUnit() {
			return this.intervalTimeUnit;
		}
		public void setIntervalTimeUnit(String intervalTimeUnit) {
			this.intervalTimeUnit = intervalTimeUnit;
		}
		public String getStartFee() {
			return this.startFee;
		}
		public void setStartFee(String startFee) {
			this.startFee = startFee;
		}

}

	/**
 * 数据列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class IssueRecord extends TaobaoObject {

	private static final long serialVersionUID = 2763957686937416854L;

	/**
		 * 权益code
		 */
		@ApiField("benefit_code")
		private String benefitCode;
		/**
		 * 权益素材
		 */
		@ApiField("benefit_material")
		private String benefitMaterial;
		/**
		 * 权益站点
		 */
		@ApiField("benefit_site")
		private String benefitSite;
		/**
		 * 权益标题
		 */
		@ApiField("benefit_title")
		private String benefitTitle;
		/**
		 * 权益类型
		 */
		@ApiField("benefit_type")
		private String benefitType;
		/**
		 * 扩展字段
		 */
		@ApiField("feature")
		private Feature feature;
		/**
		 * 中奖时间
		 */
		@ApiField("issue_time")
		private Date issueTime;
		/**
		 * 发放实例id
		 */
		@ApiField("outer_instance_id")
		private String outerInstanceId;
		/**
		 * 发放渠道
		 */
		@ApiField("send_channel")
		private String sendChannel;
		/**
		 * 投放计划code
		 */
		@ApiField("strategy_code")
		private String strategyCode;
		/**
		 * 投放站点
		 */
		@ApiField("strategy_site")
		private String strategySite;
		/**
		 * 用户
		 */
		@ApiField("user")
		private User user;
	

	public String getBenefitCode() {
			return this.benefitCode;
		}
		public void setBenefitCode(String benefitCode) {
			this.benefitCode = benefitCode;
		}
		public String getBenefitMaterial() {
			return this.benefitMaterial;
		}
		public void setBenefitMaterial(String benefitMaterial) {
			this.benefitMaterial = benefitMaterial;
		}
		public void setBenefitMaterialString(String benefitMaterial) {
			this.benefitMaterial = benefitMaterial;
		}
		
		public String getBenefitSite() {
			return this.benefitSite;
		}
		public void setBenefitSite(String benefitSite) {
			this.benefitSite = benefitSite;
		}
		public String getBenefitTitle() {
			return this.benefitTitle;
		}
		public void setBenefitTitle(String benefitTitle) {
			this.benefitTitle = benefitTitle;
		}
		public String getBenefitType() {
			return this.benefitType;
		}
		public void setBenefitType(String benefitType) {
			this.benefitType = benefitType;
		}
		public Feature getFeature() {
			return this.feature;
		}
		public void setFeature(Feature feature) {
			this.feature = feature;
		}
		public Date getIssueTime() {
			return this.issueTime;
		}
		public void setIssueTime(Date issueTime) {
			this.issueTime = issueTime;
		}
		public String getOuterInstanceId() {
			return this.outerInstanceId;
		}
		public void setOuterInstanceId(String outerInstanceId) {
			this.outerInstanceId = outerInstanceId;
		}
		public String getSendChannel() {
			return this.sendChannel;
		}
		public void setSendChannel(String sendChannel) {
			this.sendChannel = sendChannel;
		}
		public String getStrategyCode() {
			return this.strategyCode;
		}
		public void setStrategyCode(String strategyCode) {
			this.strategyCode = strategyCode;
		}
		public String getStrategySite() {
			return this.strategySite;
		}
		public void setStrategySite(String strategySite) {
			this.strategySite = strategySite;
		}
		public User getUser() {
			return this.user;
		}
		public void setUser(User user) {
			this.user = user;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Page extends TaobaoObject {

	private static final long serialVersionUID = 5735971476374718891L;

	/**
		 * 当面页数
		 */
		@ApiField("current_page")
		private Long currentPage;
		/**
		 * 每页记录数
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 数据列表
		 */
		@ApiListField("records")
		@ApiField("issue_record")
		private List<IssueRecord> records;
		/**
		 * 总记录数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public Long getCurrentPage() {
			return this.currentPage;
		}
		public void setCurrentPage(Long currentPage) {
			this.currentPage = currentPage;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public List<IssueRecord> getRecords() {
			return this.records;
		}
		public void setRecords(List<IssueRecord> records) {
			this.records = records;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
