package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.mkt.cell.interplay.execute.read response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaMktCellInterplayExecuteReadResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8313267493113664168L;

	/** 
	 * 返回结果
	 */
	@ApiField("result")
	private Result result;


	public void setResult(Result result) {
		this.result = result;
	}
	public Result getResult( ) {
		return this.result;
	}
	
	/**
 * 域能力执行结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ExecuteResultDto extends TaobaoObject {

	private static final long serialVersionUID = 5876512967561941732L;

	/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 域能力执行结果
		 */
		@ApiField("data")
		private String data;
		/**
		 * 错误信息
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getData() {
			return this.data;
		}
		public void setData(String data) {
			this.data = data;
		}
		public void setDataString(String data) {
			this.data = data;
		}
		
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}

	/**
 * 域能力请求返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InterPlayAbilityResultDto extends TaobaoObject {

	private static final long serialVersionUID = 6816316497824511499L;

	/**
		 * 域能力code
		 */
		@ApiField("ability_code")
		private String abilityCode;
		/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 域能力执行结果
		 */
		@ApiField("data")
		private ExecuteResultDto data;
		/**
		 * 错误信息
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 模块唯一标识
		 */
		@ApiField("unique_id")
		private String uniqueId;
	

	public String getAbilityCode() {
			return this.abilityCode;
		}
		public void setAbilityCode(String abilityCode) {
			this.abilityCode = abilityCode;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public ExecuteResultDto getData() {
			return this.data;
		}
		public void setData(ExecuteResultDto data) {
			this.data = data;
		}
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public String getUniqueId() {
			return this.uniqueId;
		}
		public void setUniqueId(String uniqueId) {
			this.uniqueId = uniqueId;
		}

}

	/**
 * 模块维度请求返回结果列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InterPlayModuleResultDto extends TaobaoObject {

	private static final long serialVersionUID = 8263452376572741372L;

	/**
		 * 域能力请求返回结果
		 */
		@ApiListField("ability_results")
		@ApiField("inter_play_ability_result_dto")
		private List<InterPlayAbilityResultDto> abilityResults;
		/**
		 * 模块维度请求错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 图层配置信息
		 */
		@ApiField("layer_configs")
		private String layerConfigs;
		/**
		 * 模块实例id
		 */
		@ApiField("module_id")
		private String moduleId;
		/**
		 * 模块维度请求错误信息
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 玩法id
		 */
		@ApiField("play_id")
		private Long playId;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public List<InterPlayAbilityResultDto> getAbilityResults() {
			return this.abilityResults;
		}
		public void setAbilityResults(List<InterPlayAbilityResultDto> abilityResults) {
			this.abilityResults = abilityResults;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getLayerConfigs() {
			return this.layerConfigs;
		}
		public void setLayerConfigs(String layerConfigs) {
			this.layerConfigs = layerConfigs;
		}
		public String getModuleId() {
			return this.moduleId;
		}
		public void setModuleId(String moduleId) {
			this.moduleId = moduleId;
		}
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Long getPlayId() {
			return this.playId;
		}
		public void setPlayId(Long playId) {
			this.playId = playId;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InterPlayExecuteReadResultDto extends TaobaoObject {

	private static final long serialVersionUID = 2827619749275585691L;

	/**
		 * 模块维度请求返回结果列表
		 */
		@ApiListField("module_results")
		@ApiField("inter_play_module_result_dto")
		private List<InterPlayModuleResultDto> moduleResults;
	

	public List<InterPlayModuleResultDto> getModuleResults() {
			return this.moduleResults;
		}
		public void setModuleResults(List<InterPlayModuleResultDto> moduleResults) {
			this.moduleResults = moduleResults;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 2759563369445624663L;

	/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 返回结果
		 */
		@ApiField("data")
		private InterPlayExecuteReadResultDto data;
		/**
		 * 错误信息
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public InterPlayExecuteReadResultDto getData() {
			return this.data;
		}
		public void setData(InterPlayExecuteReadResultDto data) {
			this.data = data;
		}
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
