package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.mkt.cell.interplay.execute.write response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaMktCellInterplayExecuteWriteResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7541924114265957968L;

	/** 
	 * 返回结果
	 */
	@ApiField("result")
	private Result result;


	public void setResult(Result result) {
		this.result = result;
	}
	public Result getResult( ) {
		return this.result;
	}
	
	/**
 * 域能力执行结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ExecuteResultDTO extends TaobaoObject {

	private static final long serialVersionUID = 8531476626597582295L;

	/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 域能力执行结果
		 */
		@ApiField("data")
		private String data;
		/**
		 * 错误信息
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getData() {
			return this.data;
		}
		public void setData(String data) {
			this.data = data;
		}
		public void setDataString(String data) {
			this.data = data;
		}
		
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}

	/**
 * 域能力请求返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InterPlayAbilityResultDTO extends TaobaoObject {

	private static final long serialVersionUID = 1284978433146248236L;

	/**
		 * 域能力code
		 */
		@ApiField("ability_code")
		private String abilityCode;
		/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 域能力执行结果
		 */
		@ApiField("data")
		private ExecuteResultDTO data;
		/**
		 * 错误信息
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 模块唯一标识
		 */
		@ApiField("unique_id")
		private String uniqueId;
	

	public String getAbilityCode() {
			return this.abilityCode;
		}
		public void setAbilityCode(String abilityCode) {
			this.abilityCode = abilityCode;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public ExecuteResultDTO getData() {
			return this.data;
		}
		public void setData(ExecuteResultDTO data) {
			this.data = data;
		}
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public String getUniqueId() {
			return this.uniqueId;
		}
		public void setUniqueId(String uniqueId) {
			this.uniqueId = uniqueId;
		}

}

	/**
 * 模块维度请求返回结果列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InterPlayModuleResultDTO extends TaobaoObject {

	private static final long serialVersionUID = 7252877767141633344L;

	/**
		 * 域能力请求返回结果
		 */
		@ApiListField("ability_results")
		@ApiField("inter_play_ability_result_d_t_o")
		private List<InterPlayAbilityResultDTO> abilityResults;
		/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 图层配置信息
		 */
		@ApiField("layer_configs")
		private String layerConfigs;
		/**
		 * 模块实例id
		 */
		@ApiField("module_id")
		private String moduleId;
		/**
		 * 错误信息
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 玩法id
		 */
		@ApiField("play_id")
		private Long playId;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public List<InterPlayAbilityResultDTO> getAbilityResults() {
			return this.abilityResults;
		}
		public void setAbilityResults(List<InterPlayAbilityResultDTO> abilityResults) {
			this.abilityResults = abilityResults;
		}
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getLayerConfigs() {
			return this.layerConfigs;
		}
		public void setLayerConfigs(String layerConfigs) {
			this.layerConfigs = layerConfigs;
		}
		public String getModuleId() {
			return this.moduleId;
		}
		public void setModuleId(String moduleId) {
			this.moduleId = moduleId;
		}
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Long getPlayId() {
			return this.playId;
		}
		public void setPlayId(Long playId) {
			this.playId = playId;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class InterPlayExecuteWriteResultDTO extends TaobaoObject {

	private static final long serialVersionUID = 6214812133494458457L;

	/**
		 * 模块维度请求返回结果列表
		 */
		@ApiListField("module_results")
		@ApiField("inter_play_module_result_d_t_o")
		private List<InterPlayModuleResultDTO> moduleResults;
	

	public List<InterPlayModuleResultDTO> getModuleResults() {
			return this.moduleResults;
		}
		public void setModuleResults(List<InterPlayModuleResultDTO> moduleResults) {
			this.moduleResults = moduleResults;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 6541522267415432415L;

	/**
		 * 错误码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 返回结果
		 */
		@ApiField("data")
		private InterPlayExecuteWriteResultDTO data;
		/**
		 * 错误信息
		 */
		@ApiField("msg")
		private String msg;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public InterPlayExecuteWriteResultDTO getData() {
			return this.data;
		}
		public void setData(InterPlayExecuteWriteResultDTO data) {
			this.data = data;
		}
		public String getMsg() {
			return this.msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
