package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.card.expandcard.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class CardExpandcardQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5177859785725782431L;

	/** 
	 * 接口返回model
	 */
	@ApiField("result")
	private Result result;


	public void setResult(Result result) {
		this.result = result;
	}
	public Result getResult( ) {
		return this.result;
	}
	
	/**
 * 店铺信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ShopInfoVo extends TaobaoObject {

	private static final long serialVersionUID = 3688953731693719148L;

	/**
		 * 商家id
		 */
		@ApiField("seller_id")
		private Long sellerId;
		/**
		 * 店铺icon链接
		 */
		@ApiField("shop_icon_url")
		private String shopIconUrl;
		/**
		 * 店铺id
		 */
		@ApiField("shop_id")
		private Long shopId;
		/**
		 * 店铺名称
		 */
		@ApiField("shop_name")
		private String shopName;
		/**
		 * 店铺链接
		 */
		@ApiField("shop_url")
		private String shopUrl;
	

	public Long getSellerId() {
			return this.sellerId;
		}
		public void setSellerId(Long sellerId) {
			this.sellerId = sellerId;
		}
		public String getShopIconUrl() {
			return this.shopIconUrl;
		}
		public void setShopIconUrl(String shopIconUrl) {
			this.shopIconUrl = shopIconUrl;
		}
		public Long getShopId() {
			return this.shopId;
		}
		public void setShopId(Long shopId) {
			this.shopId = shopId;
		}
		public String getShopName() {
			return this.shopName;
		}
		public void setShopName(String shopName) {
			this.shopName = shopName;
		}
		public String getShopUrl() {
			return this.shopUrl;
		}
		public void setShopUrl(String shopUrl) {
			this.shopUrl = shopUrl;
		}

}

	/**
 * 卡信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ExpandCardVo extends TaobaoObject {

	private static final long serialVersionUID = 1158284275276591867L;

	/**
		 * 品牌色
		 */
		@ApiField("brand_color")
		private String brandColor;
		/**
		 * 聚合的卡当中第一张卡的开卡时间
		 */
		@ApiField("card_create_date")
		private Date cardCreateDate;
		/**
		 * 购物金店铺icon
		 */
		@ApiField("card_icon_url")
		private String cardIconUrl;
		/**
		 * 卡名称
		 */
		@ApiField("card_name")
		private String cardName;
		/**
		 * 卡本金余额，买家在该店铺下该卡类型的所有卡实例的总本金余额
		 */
		@ApiField("card_remain_basic_money")
		private String cardRemainBasicMoney;
		/**
		 * 卡膨胀金余额，买家在该店铺下该卡类型的所有卡实例的总膨胀金余额
		 */
		@ApiField("card_remain_expand_money")
		private String cardRemainExpandMoney;
		/**
		 * 卡余额，买家在该店铺下该卡类型的所有卡实例的总余额
		 */
		@ApiField("card_remain_money")
		private String cardRemainMoney;
		/**
		 * 卡使用范围
		 */
		@ApiField("card_used_scope")
		private String cardUsedScope;
		/**
		 * 聚合的卡当中最近要过期的卡的有效期
		 */
		@ApiField("card_valid_date")
		private Date cardValidDate;
		/**
		 * 最近要过期的余额有效期描述
		 */
		@ApiField("card_valid_desc")
		private String cardValidDesc;
		/**
		 * 店铺信息
		 */
		@ApiField("shop_info_vo")
		private ShopInfoVo shopInfoVo;
		/**
		 * 目标跳转链接
		 */
		@ApiField("target_url")
		private String targetUrl;
	

	public String getBrandColor() {
			return this.brandColor;
		}
		public void setBrandColor(String brandColor) {
			this.brandColor = brandColor;
		}
		public Date getCardCreateDate() {
			return this.cardCreateDate;
		}
		public void setCardCreateDate(Date cardCreateDate) {
			this.cardCreateDate = cardCreateDate;
		}
		public String getCardIconUrl() {
			return this.cardIconUrl;
		}
		public void setCardIconUrl(String cardIconUrl) {
			this.cardIconUrl = cardIconUrl;
		}
		public String getCardName() {
			return this.cardName;
		}
		public void setCardName(String cardName) {
			this.cardName = cardName;
		}
		public String getCardRemainBasicMoney() {
			return this.cardRemainBasicMoney;
		}
		public void setCardRemainBasicMoney(String cardRemainBasicMoney) {
			this.cardRemainBasicMoney = cardRemainBasicMoney;
		}
		public String getCardRemainExpandMoney() {
			return this.cardRemainExpandMoney;
		}
		public void setCardRemainExpandMoney(String cardRemainExpandMoney) {
			this.cardRemainExpandMoney = cardRemainExpandMoney;
		}
		public String getCardRemainMoney() {
			return this.cardRemainMoney;
		}
		public void setCardRemainMoney(String cardRemainMoney) {
			this.cardRemainMoney = cardRemainMoney;
		}
		public String getCardUsedScope() {
			return this.cardUsedScope;
		}
		public void setCardUsedScope(String cardUsedScope) {
			this.cardUsedScope = cardUsedScope;
		}
		public Date getCardValidDate() {
			return this.cardValidDate;
		}
		public void setCardValidDate(Date cardValidDate) {
			this.cardValidDate = cardValidDate;
		}
		public String getCardValidDesc() {
			return this.cardValidDesc;
		}
		public void setCardValidDesc(String cardValidDesc) {
			this.cardValidDesc = cardValidDesc;
		}
		public ShopInfoVo getShopInfoVo() {
			return this.shopInfoVo;
		}
		public void setShopInfoVo(ShopInfoVo shopInfoVo) {
			this.shopInfoVo = shopInfoVo;
		}
		public String getTargetUrl() {
			return this.targetUrl;
		}
		public void setTargetUrl(String targetUrl) {
			this.targetUrl = targetUrl;
		}

}

	/**
 * 接口返回model
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 1189655968683922921L;

	/**
		 * 0为成功，其他为失败
		 */
		@ApiField("code")
		private Long code;
		/**
		 * debugInfo
		 */
		@ApiField("debug_info")
		private String debugInfo;
		/**
		 * 错误级别
		 */
		@ApiField("error_level")
		private String errorLevel;
		/**
		 * 错误信息
		 */
		@ApiField("message")
		private String message;
		/**
		 * 卡信息
		 */
		@ApiListField("models")
		@ApiField("expand_card_vo")
		private List<ExpandCardVo> models;
	

	public Long getCode() {
			return this.code;
		}
		public void setCode(Long code) {
			this.code = code;
		}
		public String getDebugInfo() {
			return this.debugInfo;
		}
		public void setDebugInfo(String debugInfo) {
			this.debugInfo = debugInfo;
		}
		public String getErrorLevel() {
			return this.errorLevel;
		}
		public void setErrorLevel(String errorLevel) {
			this.errorLevel = errorLevel;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public List<ExpandCardVo> getModels() {
			return this.models;
		}
		public void setModels(List<ExpandCardVo> models) {
			this.models = models;
		}

}



}
