package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.domain.SellerCouponDetail;
import com.taobao.api.internal.mapping.ApiListField;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.promotion.coupon.seller.search response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class PromotionCouponSellerSearchResponse extends TaobaoResponse {

	private static final long serialVersionUID = 3229587692965424893L;

	/** 
	 * 失败详细描述
	 */
	@ApiField("error_msg")
	private String errorMsg;

	/** 
	 * 接口调用结果，调用成功为true，否则为false
	 */
	@ApiField("invoke_result")
	private String invokeResult;

	/** 
	 * 调用错误码，只有调用失败的时候才会有
	 */
	@ApiField("result_code")
	private String resultCode;

	/** 
	 * 结果
	 */
	@ApiListField("seller_coupon_details")
	@ApiField("seller_coupon_detail")
	private List<SellerCouponDetail> sellerCouponDetails;

	/** 
	 * 卖家ID
	 */
	@ApiField("seller_id")
	private String sellerId;

	/** 
	 * 券对外ID
	 */
	@ApiField("spread_id")
	private String spreadId;

	/** 
	 * 符合条件总数量，用于分页等判断
	 */
	@ApiField("total_count")
	private Long totalCount;


	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}
	public String getErrorMsg( ) {
		return this.errorMsg;
	}

	public void setInvokeResult(String invokeResult) {
		this.invokeResult = invokeResult;
	}
	public String getInvokeResult( ) {
		return this.invokeResult;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}
	public String getResultCode( ) {
		return this.resultCode;
	}

	public void setSellerCouponDetails(List<SellerCouponDetail> sellerCouponDetails) {
		this.sellerCouponDetails = sellerCouponDetails;
	}
	public List<SellerCouponDetail> getSellerCouponDetails( ) {
		return this.sellerCouponDetails;
	}

	public void setSellerId(String sellerId) {
		this.sellerId = sellerId;
	}
	public String getSellerId( ) {
		return this.sellerId;
	}

	public void setSpreadId(String spreadId) {
		this.spreadId = spreadId;
	}
	public String getSpreadId( ) {
		return this.spreadId;
	}

	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}
	public Long getTotalCount( ) {
		return this.totalCount;
	}
	


}
