package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.blackbox.draw.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallBlackboxDrawGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7287757216826872718L;

	/** 
	 * 返回结果对象
	 */
	@ApiField("seiya_result")
	private SeiyaResult seiyaResult;


	public void setSeiyaResult(SeiyaResult seiyaResult) {
		this.seiyaResult = seiyaResult;
	}
	public SeiyaResult getSeiyaResult( ) {
		return this.seiyaResult;
	}
	
	/**
 * 我的抽签码列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Myqualificationcodelist extends TaobaoObject {

	private static final long serialVersionUID = 6263219127397915993L;

	/**
		 * 抽签码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 状态，0未使用，2未中签，3中签
		 */
		@ApiField("status")
		private Long status;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}

}

	/**
 * 抽象信息对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SeiyaWeiboActivityInfoDto extends TaobaoObject {

	private static final long serialVersionUID = 7788738888861264843L;

	/**
		 * 淘系活动页url
		 */
		@ApiField("activity_url")
		private String activityUrl;
		/**
		 * 业务id
		 */
		@ApiField("biz_id")
		private Long bizId;
		/**
		 * 开始抽签时间(时间戳)
		 */
		@ApiField("draw_start_time")
		private Long drawStartTime;
		/**
		 * 活动结束时间(时间戳)
		 */
		@ApiField("end_time")
		private Long endTime;
		/**
		 * 转发微博mid
		 */
		@ApiField("forward_mid")
		private String forwardMid;
		/**
		 * 微博转发文案
		 */
		@ApiField("forward_text")
		private String forwardText;
		/**
		 * 商品详情图片
		 */
		@ApiField("item_detail_pic_url")
		private String itemDetailPicUrl;
		/**
		 * 商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 商品名称
		 */
		@ApiField("item_name")
		private String itemName;
		/**
		 * 商品图片
		 */
		@ApiField("item_pic_url")
		private String itemPicUrl;
		/**
		 * 商品价格，元为单元
		 */
		@ApiField("item_price")
		private String itemPrice;
		/**
		 * 参加人数
		 */
		@ApiField("join_count")
		private Long joinCount;
		/**
		 * 最大码数
		 */
		@ApiField("max_code_size")
		private String maxCodeSize;
		/**
		 * 我的抽签码列表
		 */
		@ApiListField("my_code_list")
		@ApiField("myqualificationcodelist")
		private List<Myqualificationcodelist> myCodeList;
		/**
		 * 相关微博mid集合
		 */
		@ApiListField("other_mid_list")
		@ApiField("string")
		private List<String> otherMidList;
		/**
		 * 活动开始时间(时间戳)
		 */
		@ApiField("start_time")
		private Long startTime;
		/**
		 * 状态，0未开始，1互动中，2抽签中，3结束
		 */
		@ApiField("status")
		private String status;
	

	public String getActivityUrl() {
			return this.activityUrl;
		}
		public void setActivityUrl(String activityUrl) {
			this.activityUrl = activityUrl;
		}
		public Long getBizId() {
			return this.bizId;
		}
		public void setBizId(Long bizId) {
			this.bizId = bizId;
		}
		public Long getDrawStartTime() {
			return this.drawStartTime;
		}
		public void setDrawStartTime(Long drawStartTime) {
			this.drawStartTime = drawStartTime;
		}
		public Long getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Long endTime) {
			this.endTime = endTime;
		}
		public String getForwardMid() {
			return this.forwardMid;
		}
		public void setForwardMid(String forwardMid) {
			this.forwardMid = forwardMid;
		}
		public String getForwardText() {
			return this.forwardText;
		}
		public void setForwardText(String forwardText) {
			this.forwardText = forwardText;
		}
		public String getItemDetailPicUrl() {
			return this.itemDetailPicUrl;
		}
		public void setItemDetailPicUrl(String itemDetailPicUrl) {
			this.itemDetailPicUrl = itemDetailPicUrl;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public String getItemName() {
			return this.itemName;
		}
		public void setItemName(String itemName) {
			this.itemName = itemName;
		}
		public String getItemPicUrl() {
			return this.itemPicUrl;
		}
		public void setItemPicUrl(String itemPicUrl) {
			this.itemPicUrl = itemPicUrl;
		}
		public String getItemPrice() {
			return this.itemPrice;
		}
		public void setItemPrice(String itemPrice) {
			this.itemPrice = itemPrice;
		}
		public Long getJoinCount() {
			return this.joinCount;
		}
		public void setJoinCount(Long joinCount) {
			this.joinCount = joinCount;
		}
		public String getMaxCodeSize() {
			return this.maxCodeSize;
		}
		public void setMaxCodeSize(String maxCodeSize) {
			this.maxCodeSize = maxCodeSize;
		}
		public List<Myqualificationcodelist> getMyCodeList() {
			return this.myCodeList;
		}
		public void setMyCodeList(List<Myqualificationcodelist> myCodeList) {
			this.myCodeList = myCodeList;
		}
		public List<String> getOtherMidList() {
			return this.otherMidList;
		}
		public void setOtherMidList(List<String> otherMidList) {
			this.otherMidList = otherMidList;
		}
		public Long getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Long startTime) {
			this.startTime = startTime;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}

}

	/**
 * 返回结果对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SeiyaResult extends TaobaoObject {

	private static final long serialVersionUID = 1298154117139264539L;

	/**
		 * 抽象信息对象
		 */
		@ApiField("data")
		private SeiyaWeiboActivityInfoDto data;
		/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("error_msg")
		private String errorMsg;
		/**
		 * 是否成功
		 */
		@ApiField("is_success")
		private Boolean isSuccess;
	

	public SeiyaWeiboActivityInfoDto getData() {
			return this.data;
		}
		public void setData(SeiyaWeiboActivityInfoDto data) {
			this.data = data;
		}
		public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getErrorMsg() {
			return this.errorMsg;
		}
		public void setErrorMsg(String errorMsg) {
			this.errorMsg = errorMsg;
		}
		public Boolean getIsSuccess() {
			return this.isSuccess;
		}
		public void setIsSuccess(Boolean isSuccess) {
			this.isSuccess = isSuccess;
		}

}



}
