package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.itempromotion.item.create response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallItempromotionItemCreateResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1618755535858858743L;

	/** 
	 * 返回结果
	 */
	@ApiField("model")
	private ItemPromotionDTO model;


	public void setModel(ItemPromotionDTO model) {
		this.model = model;
	}
	public ItemPromotionDTO getModel( ) {
		return this.model;
	}
	
	/**
 * 限购信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Features extends TaobaoObject {

	private static final long serialVersionUID = 5549625288579232248L;

	/**
		 * 优惠总量限购
		 */
		@ApiField("item_promotion_item_limit")
		private String itemPromotionItemLimit;
		/**
		 * 每人优惠限购
		 */
		@ApiField("item_promotion_user_limit")
		private String itemPromotionUserLimit;
	

	public String getItemPromotionItemLimit() {
			return this.itemPromotionItemLimit;
		}
		public void setItemPromotionItemLimit(String itemPromotionItemLimit) {
			this.itemPromotionItemLimit = itemPromotionItemLimit;
		}
		public String getItemPromotionUserLimit() {
			return this.itemPromotionUserLimit;
		}
		public void setItemPromotionUserLimit(String itemPromotionUserLimit) {
			this.itemPromotionUserLimit = itemPromotionUserLimit;
		}

}

	/**
 * 商品级别报名返回信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PromUnitDTO extends TaobaoObject {

	private static final long serialVersionUID = 2752763484787668181L;

	/**
		 * 商品级别价格，单位分
		 */
		@ApiField("discount")
		private Long discount;
	

	public Long getDiscount() {
			return this.discount;
		}
		public void setDiscount(Long discount) {
			this.discount = discount;
		}

}

	/**
 * sku级别报名返回信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SkuPromUnitDTO extends TaobaoObject {

	private static final long serialVersionUID = 2182566788728134862L;

	/**
		 * 价格，单位分
		 */
		@ApiField("discount")
		private Long discount;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private Long skuId;
	

	public Long getDiscount() {
			return this.discount;
		}
		public void setDiscount(Long discount) {
			this.discount = discount;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPromotionDTO extends TaobaoObject {

	private static final long serialVersionUID = 2555356146955913287L;

	/**
		 * 活动创建人
		 */
		@ApiField("campaign_creator_id")
		private Long campaignCreatorId;
		/**
		 * 活动id
		 */
		@ApiField("campaign_id")
		private Long campaignId;
		/**
		 * 限购信息
		 */
		@ApiField("features")
		private Features features;
		/**
		 * 商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 商品级别报名返回信息
		 */
		@ApiField("item_level_prom")
		private PromUnitDTO itemLevelProm;
		/**
		 * 优惠id
		 */
		@ApiField("promotion_id")
		private Long promotionId;
		/**
		 * sku级别报名返回信息
		 */
		@ApiListField("sku_level_proms")
		@ApiField("sku_prom_unit_d_t_o")
		private List<SkuPromUnitDTO> skuLevelProms;
		/**
		 * 状态
		 */
		@ApiField("status")
		private Long status;
	

	public Long getCampaignCreatorId() {
			return this.campaignCreatorId;
		}
		public void setCampaignCreatorId(Long campaignCreatorId) {
			this.campaignCreatorId = campaignCreatorId;
		}
		public Long getCampaignId() {
			return this.campaignId;
		}
		public void setCampaignId(Long campaignId) {
			this.campaignId = campaignId;
		}
		public Features getFeatures() {
			return this.features;
		}
		public void setFeatures(Features features) {
			this.features = features;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public PromUnitDTO getItemLevelProm() {
			return this.itemLevelProm;
		}
		public void setItemLevelProm(PromUnitDTO itemLevelProm) {
			this.itemLevelProm = itemLevelProm;
		}
		public Long getPromotionId() {
			return this.promotionId;
		}
		public void setPromotionId(Long promotionId) {
			this.promotionId = promotionId;
		}
		public List<SkuPromUnitDTO> getSkuLevelProms() {
			return this.skuLevelProms;
		}
		public void setSkuLevelProms(List<SkuPromUnitDTO> skuLevelProms) {
			this.skuLevelProms = skuLevelProms;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}

}



}
