package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.itempromotion.item.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallItempromotionItemGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4163129469621652815L;

	/** 
	 * 返回值
	 */
	@ApiField("model")
	private ItemPromotionDTO model;


	public void setModel(ItemPromotionDTO model) {
		this.model = model;
	}
	public ItemPromotionDTO getModel( ) {
		return this.model;
	}
	
	/**
 * 扩展信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Features extends TaobaoObject {

	private static final long serialVersionUID = 5556666386661221372L;

	/**
		 * 优惠总量限购
		 */
		@ApiField("item_promotion_item_limit")
		private String itemPromotionItemLimit;
		/**
		 * 每人优惠限购
		 */
		@ApiField("item_promotion_user_limit")
		private String itemPromotionUserLimit;
	

	public String getItemPromotionItemLimit() {
			return this.itemPromotionItemLimit;
		}
		public void setItemPromotionItemLimit(String itemPromotionItemLimit) {
			this.itemPromotionItemLimit = itemPromotionItemLimit;
		}
		public String getItemPromotionUserLimit() {
			return this.itemPromotionUserLimit;
		}
		public void setItemPromotionUserLimit(String itemPromotionUserLimit) {
			this.itemPromotionUserLimit = itemPromotionUserLimit;
		}

}

	/**
 * sku级别报名信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SKUPromUnitDTO extends TaobaoObject {

	private static final long serialVersionUID = 2875981717175426157L;

	/**
		 * 价格，单位分
		 */
		@ApiField("discount")
		private Long discount;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private Long skuId;
	

	public Long getDiscount() {
			return this.discount;
		}
		public void setDiscount(Long discount) {
			this.discount = discount;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}

}

	/**
 * 商品级别优惠信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PromUnitDTO extends TaobaoObject {

	private static final long serialVersionUID = 7697727644398321689L;

	/**
		 * 价格，单位分
		 */
		@ApiField("discount")
		private Long discount;
	

	public Long getDiscount() {
			return this.discount;
		}
		public void setDiscount(Long discount) {
			this.discount = discount;
		}

}

	/**
 * 返回值
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ItemPromotionDTO extends TaobaoObject {

	private static final long serialVersionUID = 3248334626135914166L;

	/**
		 * 活动创建者id
		 */
		@ApiField("campaign_creator_id")
		private Long campaignCreatorId;
		/**
		 * 活动id
		 */
		@ApiField("campaign_id")
		private Long campaignId;
		/**
		 * 定向优惠活动时间范围较长，单个商品优惠时间是活动时间子集的情况下使用
		 */
		@ApiField("effective_time")
		private Date effectiveTime;
		/**
		 * 扩展信息
		 */
		@ApiField("features")
		private Features features;
		/**
		 * 商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 商品级别优惠信息
		 */
		@ApiField("item_level_prom")
		private PromUnitDTO itemLevelProm;
		/**
		 * 优惠id
		 */
		@ApiField("promotion_id")
		private Long promotionId;
		/**
		 * sku级别报名信息
		 */
		@ApiListField("sku_level_proms")
		@ApiField("s_k_u_prom_unit_d_t_o")
		private List<SKUPromUnitDTO> skuLevelProms;
		/**
		 * 状态
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 定向优惠活动时间范围较长，单个商品优惠时间是活动时间子集的情况下使用
		 */
		@ApiField("un_effective_time")
		private Date unEffectiveTime;
	

	public Long getCampaignCreatorId() {
			return this.campaignCreatorId;
		}
		public void setCampaignCreatorId(Long campaignCreatorId) {
			this.campaignCreatorId = campaignCreatorId;
		}
		public Long getCampaignId() {
			return this.campaignId;
		}
		public void setCampaignId(Long campaignId) {
			this.campaignId = campaignId;
		}
		public Date getEffectiveTime() {
			return this.effectiveTime;
		}
		public void setEffectiveTime(Date effectiveTime) {
			this.effectiveTime = effectiveTime;
		}
		public Features getFeatures() {
			return this.features;
		}
		public void setFeatures(Features features) {
			this.features = features;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public PromUnitDTO getItemLevelProm() {
			return this.itemLevelProm;
		}
		public void setItemLevelProm(PromUnitDTO itemLevelProm) {
			this.itemLevelProm = itemLevelProm;
		}
		public Long getPromotionId() {
			return this.promotionId;
		}
		public void setPromotionId(Long promotionId) {
			this.promotionId = promotionId;
		}
		public List<SKUPromUnitDTO> getSkuLevelProms() {
			return this.skuLevelProms;
		}
		public void setSkuLevelProms(List<SKUPromUnitDTO> skuLevelProms) {
			this.skuLevelProms = skuLevelProms;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Date getUnEffectiveTime() {
			return this.unEffectiveTime;
		}
		public void setUnEffectiveTime(Date unEffectiveTime) {
			this.unEffectiveTime = unEffectiveTime;
		}

}



}
