package cn.com.duiba.thirdparty.alarm;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.IOException;

/**
 * 叮叮消息
 */
public class Dingding {

    private Dingding(){
        //do nothing for fixing sonar issue
    }

    /**
     * 发送叮叮机器人消息, 接口已经公布出去暂时不能用框架的httpClient
     * @param roboot
     * @param content
     * @return
     * @throws Exception
     */
    public static String send(String roboot, String content) throws IOException {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(3000).setConnectionRequestTimeout(3000).setSocketTimeout(3000).build();
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(config).build();
        HttpPost httpPost = new HttpPost(roboot);
        httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
        String textMsg = "{ \"msgtype\": \"text\", \"text\": {\"content\": \"" + content + "\"}}";
        StringEntity se = new StringEntity(textMsg, "utf-8");
        httpPost.setEntity(se);
        try(CloseableHttpResponse response = httpclient.execute(httpPost)) {
            return EntityUtils.toString(response.getEntity(), "utf-8");
        }
    }
}
