package cn.com.duiba.thirdparty.dto;


import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;

/**
 * 扣除虚拟货币响应结果消息封装类
 */
public class VirtualCurrencyCallbackMessage implements Serializable {

    private static final long serialVersionUID = -5569615659297759353L;

	public static final String CALLBACK_TYPE_FAILED = "failed";
	public static final String CALLBACK_TYPE_CANCELLED = "cancelled";
	public static final String CALLBACK_TYPE_COMPLETED = "completed";

	//虚拟货币接口返回成功失败
	public static final String MESSAGE_TYPE_OK = "ok";
    public static final String MESSAGE_TYPE_FAIL = "fail";

    //虚拟货币返回结果变量名
    public static final String MESSAGE_STATUS = "status";
    public static final String MESSAGE_ERRORMESSAGE = "errorMessage";
    public static final String MESSAGE_BIZID = "bizId";

    private String recordId;
    private String accountId;
	private String relationId;
	private String relationType;
	private String appId;
	private String consumerId;
	private String callbackType; // failed,completed,cancelled
	private String httpUrl;
	private String message;
	private Map<String, String> params;

    public String getRecordId() {
        return recordId;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getRelationId() {
		return relationId;
	}

	public void setRelationId(String relationId) {
		this.relationId = relationId;
	}

	public String getRelationType() {
		return relationType;
	}

	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(String consumerId) {
		this.consumerId = consumerId;
	}

	public String getCallbackType() {
		return callbackType;
	}

	public void setCallbackType(String callbackType) {
		this.callbackType = callbackType;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public Map<String, String> getParams() {
		return params;
	}

	public void setParams(Map<String, String> params) {
		this.params = params;
	}

	public String getHttpUrl() {
		return httpUrl;
	}

	public void setHttpUrl(String httpUrl) {
		this.httpUrl = httpUrl;
	}

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg byte数组
     * @return VirtualCurrencyCallbackMessage
     */
    public static VirtualCurrencyCallbackMessage decode(byte[] msg) {
        String string = new String(msg, Charset.forName("utf-8"));
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return JSONObject.parseObject(string, VirtualCurrencyCallbackMessage.class);
    }

}
