package cn.com.duiba.thirdpartyvnew.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.VirtualCardMessage;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 扣虚拟卡服务
 * Created by xiaoxuda on 2017/8/30.
 */
@AdvancedFeignClient
public interface RemoteVirtualCardService {
    /**
     * 扣虚拟卡接口<br/>
     * 1.将扣虚拟卡请求丢到HTTP请求池中<br/>
     * 2.返回Boolean是否提交成功<br/>
     * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
     * 4.业务方订阅callbackTopic队列进行后续流程<br/>
     *
     * @param request 扣虚拟卡请求参数
     * @param msgTopic 扣积分回调topic
     * @param msgTag 标签，对消息进行再归类，可为null
     * @param msgKey 消息平台唯一键，用于在消息平台查找消息,可为null
     * @return boolean ture:提交成功   false:提交失败
     */
    DubboResult<Boolean> submitSubVirtualCard(VirtualCardMessage request, String msgTopic, String msgTag, String msgKey);


}
