package cn.com.duiba.thirdpartyvnew.dto.devapp;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 广告监测链接回传
 * 字节回传文档：https://event-manager.oceanengine.com/docs/8650/app_api_docs
 * 字节
 */
@NoArgsConstructor
@Data
public class AppAdTrackingByteLinkCallbackDto implements Serializable {

    private static final long serialVersionUID = -1L;

    @JSONField(name = "event_type")
    private String eventType;

    private JSONObject context;

    private Long timestamp;

    @NoArgsConstructor
    @Data
    public static class Ad {
        @JSONField(name = "match_type")
        private Integer matchType;

        private String callback;
    }
}
